% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMD.R
\name{.interaction_SMD}
\alias{.interaction_SMD}
\title{Interaction effect: Standardized mean difference}
\usage{
.interaction_SMD(
  Ctrl_mean,
  Ctrl_sd,
  Ctrl_n,
  A_mean,
  A_sd,
  A_n,
  B_mean,
  B_sd,
  B_n,
  AB_mean,
  AB_sd,
  AB_n,
  hedges_correction = TRUE
)
}
\arguments{
\item{Ctrl_mean}{Mean outcome from the Control treatment}

\item{Ctrl_sd}{Standard deviation from the control treatment}

\item{Ctrl_n}{Sample size from the control treatment}

\item{A_mean}{Mean outcome from the treatment}

\item{A_sd}{Standard deviation from the treatment}

\item{A_n}{Sample size from the treatment}

\item{B_mean}{Mean outcome from the B treatment}

\item{B_sd}{Standard deviation from the B treatment}

\item{B_n}{Sample size from the B treatment}

\item{AB_mean}{Mean outcome from the interaction AxB treatment}

\item{AB_sd}{Standard deviation from the interaction AxB treatment}

\item{AB_n}{Sample size from the interaction AxB treatment}

\item{hedges_correction}{Logical. Apply or not Hedges' correction for small-sample bias. Default is TRUE}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Computes the interaction effect between factors A and B in factorial
data.
}
\details{
See the package vignette for a detailed description of the formula.
}
\examples{
data <- data.frame(
  study_id = 1:2,
  control_mean = c(24.8, 27.2), control_sd = c(4.1, 4.6), control_n = c(18, 16),
  salinity_mean = c(19.3, 21.7), salinity_sd = c(3.8, 4.2), salinity_n = c(17, 18),
  temperature_mean = c(28.9, 31.4), temperature_sd = c(4.7, 5.1), temperature_n = c(19, 15),
  salt_temp_mean = c(15.2, 17.8), salt_temp_sd = c(3.1, 3.5), salt_temp_n = c(16, 17)
)

result <- SMD_inter(
  data = data,
  Ctrl_mean = "control_mean", Ctrl_sd = "control_sd", Ctrl_n = "control_n",
  A_mean = "salinity_mean", A_sd = "salinity_sd", A_n = "salinity_n",
  B_mean = "temperature_mean", B_sd = "temperature_sd", B_n = "temperature_n",
  AB_mean = "salt_temp_mean", AB_sd = "salt_temp_sd", AB_n = "salt_temp_n"
)

}
\references{
Gurevitch, J., Morrison, J. A., & Hedges, L. V. (2000). The interaction
between competition and predation: a meta-analysis of field experiments.
The American Naturalist, 155(4), 435-453.

Morris, W. F., Hufbauer, R. A., Agrawal, A. A., Bever, J. D., Borowicz, V. A.,
Gilbert, G. S., ... & Vázquez, D. P. (2007). Direct and interactive
effects of enemies and mutualists on plant performance: a meta‐analysis.
Ecology, 88(4), 1021-1029. https://doi.org/10.1890/06-0442
}
\author{
Facundo Decunta - fdecunta@agro.uba.ar
}
\keyword{internal}
