% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMD.R
\name{.main_SMD}
\alias{.main_SMD}
\title{Main effect: Standardized Mean Difference}
\usage{
.main_SMD(
  Ctrl_mean,
  Ctrl_sd,
  Ctrl_n,
  A_mean,
  A_sd,
  A_n,
  B_mean,
  B_sd,
  B_n,
  AB_mean,
  AB_sd,
  AB_n,
  hedges_correction = TRUE
)
}
\arguments{
\item{Ctrl_mean}{Mean outcome from the Control treatment}

\item{Ctrl_sd}{Standard deviation from the control treatment}

\item{Ctrl_n}{Sample size from the control treatment}

\item{A_mean}{Mean outcome from the A treatment}

\item{A_sd}{Standard deviation from the A treatment}

\item{A_n}{Sample size from the A treatment}

\item{B_mean}{Mean outcome from the B treatment}

\item{B_sd}{Standard deviation from the B treatment}

\item{B_n}{Sample size from the B treatment}

\item{AB_mean}{Mean outcome from the interaction AxB treatment}

\item{AB_sd}{Standard deviation from the interaction AxB treatment}

\item{AB_n}{Sample size from the interaction AxB treatment}

\item{hedges_correction}{Boolean. If TRUE correct for small-sample bias. Default is TRUE.}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Computes the main effect of Factor A across levels of Factor B, analogous
to the main effect in a factorial ANOVA.
}
\details{
See the package vignette for a detailed description of the formula.
}
\examples{
# Main effect of Mycorrhiza in 2x2 factorial design (AMF x Phosphorus)
data <- data.frame(
  study_id = 1:2,
  control_mean = c(12.4, 15.1), control_sd = c(2.8, 3.2), control_n = c(16, 14),
  mycorrhizae_mean = c(18.7, 21.3), mycorrhizae_sd = c(3.4, 3.9), mycorrhizae_n = c(15, 16),
  phosphorus_mean = c(14.9, 17.8), phosphorus_sd = c(3.1, 3.6), phosphorus_n = c(17, 13),
  myco_phos_mean = c(22.1, 25.4), myco_phos_sd = c(4.2, 4.8), myco_phos_n = c(14, 15)
)

result <- SMD_main(
  data = data,
  Ctrl_mean = "control_mean", Ctrl_sd = "control_sd", Ctrl_n = "control_n",
  A_mean = "mycorrhizae_mean", A_sd = "mycorrhizae_sd", A_n = "mycorrhizae_n",
  B_mean = "phosphorus_mean", B_sd = "phosphorus_sd", B_n = "phosphorus_n",
  AB_mean = "myco_phos_mean", AB_sd = "myco_phos_sd", AB_n = "myco_phos_n"
)

}
\references{
Gurevitch, J., Morrison, J. A., & Hedges, L. V. (2000). The interaction
between competition and predation: a meta-analysis of field experiments.
The American Naturalist, 155(4), 435-453.

Morris, W. F., Hufbauer, R. A., Agrawal, A. A., Bever, J. D., Borowicz, V. A.,
Gilbert, G. S., ... & Vázquez, D. P. (2007). Direct and interactive
effects of enemies and mutualists on plant performance: a meta‐analysis.
Ecology, 88(4), 1021-1029. https://doi.org/10.1890/06-0442
}
\author{
Facundo Decunta - fdecunta@agro.uba.ar
}
\keyword{internal}
