% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promises.R
\name{as.promise.mirai_map}
\alias{as.promise.mirai_map}
\title{Make mirai_map Promise}
\usage{
\method{as.promise}{mirai_map}(x)
}
\arguments{
\item{x}{(mirai_map) object to convert to promise.}
}
\value{
A 'promise' object.
}
\description{
Creates a 'promise' from a 'mirai_map'. S3 method for
\code{promises::as.promise()}.
}
\details{
Allows a 'mirai_map' to be used with the promise pipe \verb{\%...>\%}, scheduling a
function to run upon resolution of all mirai.

Uses \code{promises::promise_all()} internally: resolves to a list of values if
all succeed, or rejects with the first error encountered.

Requires the \pkg{promises} package.
}
\examples{
\dontshow{if (interactive() && requireNamespace("promises", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(promises)

with(daemons(1), {
  mp <- mirai_map(1:3, function(x) { Sys.sleep(1); x })
  p <- as.promise(mp)
  print(p)
  p \%...>\% print
  mp[.flat]
})
\dontshow{\}) # examplesIf}
}
