% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{with.miraiDaemons}
\alias{with.miraiDaemons}
\title{With Mirai Daemons}
\usage{
\method{with}{miraiDaemons}(data, expr, ...)
}
\arguments{
\item{data}{(miraiDaemons) return value from \code{\link[=daemons]{daemons()}}.}

\item{expr}{(expression) to evaluate with daemons active.}

\item{...}{unused.}
}
\value{
The return value of \code{expr}.
}
\description{
Evaluate an expression with daemons that last for the duration of the
expression. Ensure each mirai within the statement is explicitly called (or
their values collected) so that daemons are not reset before they have all
completed.
}
\details{
This function is an S3 method for the generic \code{\link[=with]{with()}} for class
'miraiDaemons'.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
with(
  daemons(2, dispatcher = FALSE),
  {
    m1 <- mirai(Sys.getpid())
    m2 <- mirai(Sys.getpid())
    cat(m1[], m2[], "\n")
  }
)

Sys.getpid()
\dontshow{\}) # examplesIf}
}
