% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item.reverse.R
\name{item.reverse}
\alias{item.reverse}
\title{Reverse Code Scale Item}
\usage{
item.reverse(data, ..., min = NULL, max = NULL, keep = NULL, append = TRUE,
             name = ".r", as.na = NULL, table = FALSE, check = TRUE)
}
\arguments{
\item{data}{a numeric vector for reverse coding an item or data frame
for reverse coding more than one item.}

\item{...}{an expression indicating the variable names in \code{data} e.g.,
\code{item.reverse(x1, x2, x3, data = dat)}. Note that the operators
\code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{min}{an integer indicating the minimum of the item (i.e., lowest possible
scale value).}

\item{max}{an integer indicating the maximum of the item (i.e., highest possible
scale value).}

\item{keep}{a numeric vector indicating values not to be reverse coded.}

\item{append}{logical: if \code{TRUE} (default), recoded variable(s) are
appended to the data frame specified in the argument \code{data}.}

\item{name}{a character string or character vector indicating the names
of the reverse coded item. By default, variables are named with the ending
\code{".r"} resulting in e.g. \code{"x1.r"} and \code{"x2.r"}. Variable names
can also be specified using a character vector matching the number
of variables (e.g., \code{name = c("reverse.x1", "reverse.x2")}).}

\item{as.na}{a numeric vector indicating user-defined missing values, i.e. these
values are converted to \code{NA} before conducting the analysis.}

\item{table}{logical: if \code{TRUE}, a cross table item x reverse coded item
is printed on the console if only one variable is specified.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns a numeric vector or data frame with the same length or same number of
rows as \code{data} containing the reverse coded scale item(s).
}
\description{
This function reverse codes inverted items, i.e., items that are negatively
worded.
}
\details{
If arguments \code{min} and/or \code{max} are not specified, empirical minimum
and/or maximum is computed from the data Note, however, that reverse coding
might fail if the lowest or highest possible scale value is not represented in
the data That is, it is always preferable to specify the arguments \code{min}
and \code{max}.
}
\examples{
dat <- data.frame(item1 = c(1, 5, 3, 1, 4, 4, 1, 5),
                  item2 = c(1, 1.3, 1.7, 2, 2.7, 3.3, 4.7, 5),
                  item3 = c(4, 2, 4, 5, 1, 3, 5, -99))

# Example 1: Reverse code 'item1' and append to 'dat'
item.reverse(dat, item1, min = 1, max = 5)

# Alternative specification without using the '...' argument
item.reverse(dat$item1, min = 1, max = 5)

# Example 2: Reverse code 'item3' while keeping the value -99
item.reverse(dat, item3, min = 1, max = 5, keep = -99)

# Example 3: Reverse code 'item3' while keeping the value -99 and check recoding
item.reverse(dat, item3, min = 1, max = 5, keep = -99, table = TRUE)

# Example 4: Reverse code 'item1', 'item2', and 'item3' and attach to 'dat'
item.reverse(item1:item3, data = dat, min = 1, max = 5, keep = -99)

# Alternative specification without using the '...' argument
dat <- cbind(dat,
             item.reverse(dat[, c("item1", "item2", "item3")],
                          min = 1, max = 5, keep = -99))
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.
}
\seealso{
\code{\link{item.alpha}}, \code{\link{item.omega}}, \code{\link{rec}},
\code{\link{item.scores}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
