% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammapar.R
\name{to_mu_sd_gamma}
\alias{to_mu_sd_gamma}
\title{Parameter Conversion for Gamma Distribution}
\usage{
to_mu_sd_gamma(alpha, lambda)
}
\arguments{
\item{alpha}{a numeric vector representing the shape of one or more than one gamma distributions}

\item{lambda}{a numeric vector representing the rate of one or more than one gamma distributions.
\code{alpha} and \code{lambda} should have the same length.}
}
\value{
a list of two items
\item{mu}{a vector of the means of gamma distributions}
\item{sd}{a vector of the standard deviations of gamma distributions}
}
\description{
The function \code{to_mu_sd_gamma} converts the shape and rate to the mean and standard deviation
}
\details{
The purpose of this function is to convert the parameterization of gamma distribution in the form of
shape and rate to the form of mean and standard deviation.
}
\examples{
to_mu_sd_gamma(2, 1)
to_mu_sd_gamma(c(2, 4), c(1, 1))

}
\seealso{
\code{\link{to_shape_rate_gamma}}
}
