#' Default S3 print method for process object (derived from `process()`)
#'
#' This function sets up the default print method
#' for outputs from process function
#'
#' @param x process object as generated by deconvolve
#' @param ... other options passed to plot
#' @return print output
#' @method print process
#'
#' @export

print.process <- function (x, ...) {

  cat(paste('Derivative thermogravimetry data (DTG) calculated for\n',
            nrow(x$data), 'datapoints from',
            round(x$temp_range[1], 2), 'to',
            round(x$temp_range[2], 2), 'degrees C.'))

}

