% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process}
\alias{process}
\title{Calculates the derivative rate of mass loss of thermogravimetric data}
\usage{
process(data, init_mass, temp, mass_loss = NULL, mass = NULL,
  temp_units = "C")
}
\arguments{
\item{data}{dataframe}

\item{init_mass}{numeric value of initial sample mass in mg}

\item{temp}{column name containing temperature values}

\item{mass_loss}{column name containing mass loss values in mg}

\item{mass}{column name containing mass values in mg}

\item{temp_units}{specify units of temperature, default = Celsius.
Can specify 'K' or 'Kelvin' if in Kelvin}
}
\value{
process list containing modified dataframe, initial mass
of sample, and maximum and minimum temperature values
}
\description{
This function processes thermogravimetric data by calculating
the derivative of mass loss
}
\examples{
data(juncus)
tmp <- process(juncus, init_mass = 18.96,
               temp = 'temp_C', mass_loss = 'mass_loss')

}
\keyword{deconvolution}
\keyword{fraser-suzuki}
\keyword{thermogravimetry}
