% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_likelihood.R
\name{logLik.covlmc}
\alias{logLik.covlmc}
\title{Log-Likelihood of a VLMC with covariates}
\usage{
\method{logLik}{covlmc}(object, initial = c("truncated", "specific", "extended"), ...)
}
\arguments{
\item{object}{the covlmc representation.}

\item{initial}{specifies the likelihood function, more precisely the way the
first few observations for which contexts cannot be calculated are
integrated in the likelihood. Defaults to \code{"truncated"}. See
\code{\link[=loglikelihood]{loglikelihood()}} for details.}

\item{...}{additional parameters for logLik.}
}
\value{
an object of class \code{logLik}. This is a number, the log-likelihood of
the (CO)VLMC with the following attributes:
\itemize{
\item \code{df}: the number of parameters used by the VLMC for this likelihood calculation
\item \code{nobs}: the number of observations included in this likelihood calculation
\item \code{initial}: the value of the \code{initial} parameter used to compute this likelihood
}
}
\description{
This function evaluates the log-likelihood of a VLMC with covariates
fitted on a discrete time series.
}
\examples{

## Likelihood for a fitted VLMC with covariates.
pc <- powerconsumption[powerconsumption$week == 5, ]
breaks <- c(
  0,
  median(powerconsumption$active_power, na.rm = TRUE),
  max(powerconsumption$active_power, na.rm = TRUE)
)
labels <- c(0, 1)
dts <- cut(pc$active_power, breaks = breaks, labels = labels)
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
ll <- logLik(m_cov)
attributes(ll)

}
\seealso{
\code{\link[=loglikelihood]{loglikelihood()}}
}
