% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlearning.R
\name{mlearning}
\alias{mlearning}
\alias{print.mlearning}
\alias{summary.mlearning}
\alias{print.summary.mlearning}
\alias{plot.mlearning}
\alias{predict.mlearning}
\alias{cvpredict}
\alias{cvpredict.mlearning}
\title{Machine learning model for (un)supervised classification or regression}
\usage{
mlearning(
  formula,
  data,
  method,
  model.args,
  call = match.call(),
  ...,
  subset,
  na.action = na.fail
)

\method{print}{mlearning}(x, ...)

\method{summary}{mlearning}(object, ...)

\method{print}{summary.mlearning}(x, ...)

\method{plot}{mlearning}(x, y, ...)

\method{predict}{mlearning}(
  object,
  newdata,
  type = c("class", "membership", "both"),
  method = c("direct", "cv"),
  na.action = na.exclude,
  ...
)

cvpredict(object, ...)

\method{cvpredict}{mlearning}(
  object,
  type = c("class", "membership", "both"),
  cv.k = 10,
  cv.strat = TRUE,
  ...
)
}
\arguments{
\item{formula}{a formula with left term being the factor variable to predict
(for supervised classification), a vector of numbers (for regression) or
nothing (for unsupervised classification) and the right term with the list
of independent, predictive variables, separated with a plus sign. If the
data frame provided contains only the dependent and independent variables,
one can use the \code{class ~ .} short version (that one is strongly encouraged).
Variables with minus sign are eliminated. Calculations on variables are
possible according to usual formula convention (possibly protected by using
\code{I()}). Supervised classification, regression or unsupervised classification
are not available for all algorithms. Check respective help pages.}

\item{data}{a data.frame to use as a training set.}

\item{method}{\code{"direct"} (default) or \code{"cv"}. \code{"direct"} predicts new cases
in \verb{newdata=} if this argument is provided, or the cases in the training
set if not. Take care that not providing \verb{newdata=} means that you just
calculate the \strong{self-consistency} of the classifier but cannot use the
metrics derived from these results for the assessment of its performances.
Either use a different dataset in \verb{newdata=} or use the alternate
cross-validation ("cv") technique. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case. Other
methods may be provided by the various algorithms (check their help pages)}

\item{model.args}{arguments for formula modeling with substituted data and
subset... Not to be used by the end-user.}

\item{call}{the function call. Not to be used by the end-user.}

\item{...}{further arguments (depends on the method).}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_qda]{ml_qda()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{x, object}{an \strong{mlearning} object}

\item{y}{a second \strong{mlearning} object or nothing (not used in several plots)}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. \code{"class"} by default, the
predicted classes. Other options are \code{"membership"} the membership (a
number between 0 and 1) to the different classes, or \code{"both"} to return
classes and memberships. Other types may be provided for some algorithms
(read respective help pages).}

\item{cv.k}{k for k-fold cross-validation, cf \code{\link[ipred:errorest]{ipred::errorest()}}.
By default, 10.}

\item{cv.strat}{is the subsampling stratified or not in cross-validation,
cf \code{\link[ipred:errorest]{ipred::errorest()}}. \code{TRUE} by default.}
}
\value{
an \strong{mlearning} object for \code{\link[=mlearning]{mlearning()}}. Methods return their own
results that can be a \strong{mlearning}, \strong{data.frame}, \strong{vector}, etc.
}
\description{
An \strong{mlearning} object provides an unified (formula-based) interface to
several machine learning algorithms. They share the same interface and very
similar arguments. They conform to the formula-based approach, of say,
\code{\link[stats:lm]{stats::lm()}} in base R, but with a coherent handling of missing data and
missing class levels. An optimized version exists for the simplified \code{y ~ .}
formula. Finally, cross-validation is also built-in.
}
\examples{
# mlearning() should not be calle directly. Use the mlXXX() functions instead
# for instance, for Random Forest, use ml_rforest()/mlRforest()
# A typical classification involves several steps:
#
# 1) Prepare data: split into training set (2/3) and test set (1/3)
#    Data cleaning (elimination of unwanted variables), transformation of
#    others (scaling, log, ratios, numeric to factor, ...) may be necessary
#    here. Apply the same treatments on the training and test sets
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133) # Also random or stratified sampling
iris_train <- iris[train, ]
iris_test <- iris[-train, ]

# 2) Train the classifier, use of the simplified formula class ~ . encouraged
#    so, you may have to prepare the train/test sets to keep only relevant
#    variables and to possibly transform them before use
iris_rf <- ml_rforest(data = iris_train, Species ~ .)
iris_rf
summary(iris_rf)
train(iris_rf)
response(iris_rf)

# 3) Find optimal values for the parameters of the model
#    This is usally done iteratively. Just an example with ntree where a plot
#    exists to help finding optimal value
plot(iris_rf)
# For such a relatively simple case, 50 trees are enough, retrain with it
iris_rf <- ml_rforest(data = iris_train, Species ~ ., ntree = 50)
summary(iris_rf)

# 4) Study the classifier performances. Several metrics and tools exists
#    like ROC curves, AUC, etc. Tools provided here are the confusion matrix
#    and the metrics that are calculated on it.
predict(iris_rf) # Default type is class
predict(iris_rf, type = "membership")
predict(iris_rf, type = "both")
# Confusion matrice and metrics using 10-fols cross-validation
iris_rf_conf <- confusion(iris_rf, method = "cv")
iris_rf_conf
summary(iris_rf_conf)
# Note you may want to manipulate priors too, see ?prior

# 5) Go back to step #1 and refine the process until you are happy with the
#    results. Then, you can use the classifier to predict unknown items.
}
\seealso{
\code{\link[=ml_lda]{ml_lda()}}, \code{\link[=ml_qda]{ml_qda()}}, \code{\link[=ml_naive_bayes]{ml_naive_bayes()}}, \code{\link[=ml_nnet]{ml_nnet()}},
\code{\link[=ml_rpart]{ml_rpart()}}, \code{\link[=ml_rforest]{ml_rforest()}}, \code{\link[=ml_svm]{ml_svm()}}, \code{\link[=confusion]{confusion()}} and \code{\link[=prior]{prior()}}. Also
\code{\link[ipred:errorest]{ipred::errorest()}} that internally computes the cross-validation
in \code{cvpredict()}.
}
