% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlim.summarize.R
\name{mlim.summarize}
\alias{mlim.summarize}
\title{mlim imputation summary}
\usage{
mlim.summarize(data)
}
\arguments{
\item{data}{dataset imputed with mlim}
}
\value{
estimated imputation accuracy via cross-valdiation procedure
}
\description{
provides information about estimated accuracy of the imputation as well
             as the overall procedure of the imputation.
}
\examples{
\dontrun{
data(iris)

# add 10\% stratified missing values to one factor variable
irisNA <- iris
irisNA$Species <- mlim.na(irisNA$Species, p = 0.1, stratify = TRUE, seed = 2022)

# run the ELNET single imputation (fastest imputation via 'mlim')
MLIM <- mlim(irisNA)

# in single imputation, you can estimate the imputation accuracy via cross validation RMSE
mlim.summarize(MLIM)
}
}
\author{
E. F. Haghish
}
