% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingNestedCV.R
\name{mlr_resamplings_ncv}
\alias{mlr_resamplings_ncv}
\alias{ResamplingNestedCV}
\title{Nested Cross-Validation}
\description{
This implements the Nested CV resampling procedure by Bates et al. (2024).
}
\section{Point Estimation}{

When calling \verb{$aggregate()} on a resample result obtained using this resampling method, only
the outer resampling iterations will be used, as they have a smaller bias.
See section "Point Estimation" of \code{\link[=mlr_measures_ci.ncv]{MeasureCiNestedCV}}.
}

\section{Parameters}{

\itemize{
\item \code{folds} :: \code{integer(1)}\cr
The number of folds. This is initialized to \code{5}.
\item \code{repeats} :: \code{integer(1)}\cr
The number of repetitions. THis is initialized to \code{10}.
}
}

\examples{
ncv = rsmp("ncv", folds = 3, repeats = 10L)
ncv
rr = resample(tsk("mtcars"), lrn("regr.featureless"), ncv)
}
\references{
Bates, Stephen, Hastie, Trevor, Tibshirani, Robert (2024).
\dQuote{Cross-validation: what does it estimate and how well does it do it?}
\emph{Journal of the American Statistical Association}, \bold{119}(546), 1434--1445.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingNestedCV}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{(\code{integer(1)})\cr
The total number of resampling iterations.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingNestedCV-new}{\code{ResamplingNestedCV$new()}}
\item \href{#method-ResamplingNestedCV-unflatten}{\code{ResamplingNestedCV$unflatten()}}
\item \href{#method-ResamplingNestedCV-clone}{\code{ResamplingNestedCV$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="instantiate"><a href='../../mlr3/html/Resampling.html#method-Resampling-instantiate'><code>mlr3::Resampling$instantiate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingNestedCV-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingNestedCV-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingNestedCV$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingNestedCV-unflatten"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingNestedCV-unflatten}{}}}
\subsection{Method \code{unflatten()}}{
Convert a resampling iteration to a more useful representation.
For outer resampling iterations, \code{inner} is \code{NA}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingNestedCV$unflatten(iter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iter}}{(\code{integer(1)})\cr
The iteration.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{list(rep, outer, inner)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingNestedCV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingNestedCV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingNestedCV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
