% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_statistics.R
\name{heter_covariate}
\alias{heter_covariate}
\title{Long memory tests for non-stationary time series regression}
\usage{
heter_covariate(
  data,
  param = list(B = 2000, lrvmethod = 1, gcv = 1, neighbour = 1, lb = 3, ub = 11, tau_n =
    0.3, type = "KPSS"),
  mvselect = -1,
  bw = 0.2,
  shift = 1,
  verbose_dist = FALSE,
  hyper = FALSE
)
}
\arguments{
\item{data}{a list with the vector y and the matrix x, for example, list(x=...,y=...).}

\item{param}{a list of parameters, list(B =..., lrvmethod =...,gcv = ..., neighbour =..., lb = ..., ub = ..., tau_n = ..., type = ..., ind = ...)}

\item{mvselect}{the value of moving window parameter \mjseqn{m}. In addition, mvselect=-1 provides data-driven smoothing parameters via Minimum Volatility of the long-run covariance estimator as proposed in Chapter 9 of Politis et al.(1999), while mvselect = -2 provides data-driven smoothing parameters via Minimum Volatility of the bootstrap statistics, see Bai and Wu (2024a).}

\item{bw}{the bandwidth parameter in the local linear regression, default 0.2.}

\item{shift}{modify bw by a factor, default 1.}

\item{verbose_dist}{whether to print intermediate results, i.e., the bootstrap distribution and statistics, default FALSE.}

\item{hyper}{whether to only print the selected values of the smoothing parameters,\mjseqn{m} and \mjseqn{\tau_n}, default FALSE.}
}
\value{
p-value of the long memory test
}
\description{
\loadmathjax Test for long memory of \mjseqn{e_i} in the time series regression \deqn{y_i = x_i \beta_i + e_i, 1\le i \le n} where \mjseqn{x_i} is the multivariate covariate process with first component 1, \mjseqn{\beta_i} is the functional coefficient, \mjseqn{e_i} is the error term which can be long memory. In particular,covariates and the error term are allowed to be dependent.
}
\details{
param
\itemize{
\item B, the number of bootstrap simulation, say 2000
*lrvmethod,  the method of long-run variance estimation, lrvmethod = 0 uses the plug-in estimator in Zhou (2010), lrvmethod = 1 offers the debias difference-based estimator in Bai and Wu (2024b), lrvmethod = 2 provides the plug-in estimator using the \mjseqn{\breve{\beta}}, the pilot estimator proposed in Bai and Wu (2024b)
\item gcv,  1 or 0, whether to use Generalized Cross Validation for the selection of \mjseqn{b}, the bandwidth parameter in the local linear regression
\item neighbour, the number of neighbours in the extended minimum volatility, for example 1,2 or 3
\item lb, the lower bound of the range of \mjseqn{m} in the extended minimum volatility Selection
\item ub,  the upper bound of the range of \mjseqn{m} in the extended minimum volatility Selection
\item bw_set, the proposed grid of the range of bandwidth selection. if not presented, a rule of thumb method will be used for the data-driven range
\item tau_n,  the value of \mjseqn{\tau} when no data-driven selection is used. if \mjseqn{\tau} is set to \mjseqn{0}, the rule of thumb \mjseqn{n^{-2/15}} will be used
\item type, c( "KPSS","RS","VS","KS") type of tests, see  Bai and Wu (2024a).
\item ind,  types of kernels
\item 1 Triangular \mjseqn{1-|u|}, \mjseqn{u \le 1}
\item 2 Epanechnikov kernel \mjseqn{3/4(1 - u^{2})}, \mjseqn{u \le 1}
\item 3 Quartic \mjseqn{15/16(1 - u^{2})^{2}}, \mjseqn{u \le 1}
\item 4 Triweight \mjseqn{35/32(1 - u^{2})^{3}}, \mjseqn{u \le 1}
\item 5 Tricube  \mjseqn{70/81(1 - |u|^{3})^{3}}, \mjseqn{u \le 1}
}
}
\section{mlrv functions}{

Heter_LRV, heter_covariate, heter_gradient, gcv_cov, MV_critical
}

\examples{
param = list(d = -0.2, heter = 2, tvd = 0,
 tw = 0.8, rate = 0.1, cur = 1,
 center = 0.3, ma_rate =  0, cov_tw =  0.2,
 cov_rate = 0.1, cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
data = Qct_reg(1000, param)
### KPSS test B
heter_covariate(data, list(B=20, lrvmethod = 1,
gcv = 1, neighbour = 1, lb = 3, ub = 11, type = "KPSS"), mvselect = -2, verbose_dist = TRUE)
}
\references{
Bai, L., & Wu, W. (2024a). Detecting long-range dependence for time-varying linear models. Bernoulli, 30(3), 2450-2474.

Bai, L., & Wu, W. (2024b). Difference-based covariance matrix estimation in time series nonparametric regression with application to specification tests. Biometrika, asae013.

Zhou, Z. and Wu, W. B. (2010). Simultaneous inference of linear models with time varying coefficients.J. R. Stat. Soc. Ser. B. Stat. Methodol., 72(4):513–531.

Politis, D. N., Romano, J. P., and Wolf, M. (1999). Subsampling. Springer Science & Business Media.
}
