% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deck_funcs.R
\name{deal_card}
\alias{deal_card}
\title{Deal a Card from the Deck}
\usage{
deal_card(current_deck)
}
\arguments{
\item{current_deck}{A data frame representing the current deck of cards. This
can either be a standard deck, an anonymous deck, or an interleaved deck.
The function also accepts an object of class "UpDeck" which contains an
updated deck and the last dealt card.}
}
\value{
A list containing two elements: \code{dealt_card}, a data frame representing
the card that was dealt, and \code{updated_deck}, a data frame representing the
remaining cards in the deck. The list has the class attribute "UpDeck".
}
\description{
This function deals the top card from a given deck and returns the dealt card
along with the updated deck.
}
\examples{
# Using a standard deck
std_deck <- standard_deck()
result <- deal_card(std_deck)
result$dealt_card
result$updated_deck

# Using an "UpDeck" object
result2 <- deal_card(result)
result2$dealt_card
result2$updated_deck

}
