% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmtsne.R
\name{mmtsne}
\alias{mmtsne}
\title{Multiple maps t-SNE}
\usage{
mmtsne(X, no_maps = 1, no_dims = 2, perplexity = 30, max_iter = 500,
  momentum = 0.5, final_momentum = 0.8, mom_switch_iter = 250,
  eps = 1e-07)
}
\arguments{
\item{X}{A dataframe or matrix of \eqn{N} rows and \eqn{D} columns.}

\item{no_maps}{The number of maps (positive whole number) to be estimated.}

\item{no_dims}{The number of dimensions per map. Typical values are 2 or 3.}

\item{perplexity}{The target perplexity for probability matrix
construction. Commonly recommended values range from 5 to 30.
Perplexity roughly corresponds to the expected number of neighbors
per data point.}

\item{max_iter}{The number of iterations to run.}

\item{momentum}{Constant scaling factor for update momentum in gradient
descent algorithm.}

\item{final_momentum}{Constant scaling factor for update momentum in gradient
descent algorithm after the momentum switch point.}

\item{mom_switch_iter}{The iteration at which momentum switches from
\code{momentum} to \code{final_momentum}.}

\item{eps}{A small positive value near zero.}
}
\value{
A list that includes the following objects:
   \describe{
   \item{Y}{An \code{N x no_dims x no_maps} array of predicted coordinates.}
   \item{weights}{An \code{N x no_maps} matrix of unscaled weights. A high
       weight on entry \eqn{i, j} indicates a greater contribution of point
       \eqn{i} on map \eqn{j}.}
   \item{proportions}{An \code{N x no_maps} matrix of scaled weights. A high
       weight on entry \eqn{i, j} indicates a greater contribution of point
       \eqn{i} on map \eqn{j}.}
   }
}
\description{
\code{mmtsne} estimates a multiple maps t-distributed stochastic neighbor
   embedding (multiple maps t-SNE) model.
}
\details{
\code{mmtsne} is a wrapper that performs multiple maps t-SNE on an input
   dataset, \code{X}. The function will pre-process \code{X}, an \eqn{N}
   by \eqn{D} matrix or dataframe, then call \code{\link{mmtsneP}}.
   The pre-processing steps include calls to \code{\link{x2p}} and
   \code{\link{p2sp}} to convert \code{X} into an \eqn{N} by \eqn{N}
   symmetrical joint probability matrix.

The \code{mmtnseP} code is an almost direct port of the original multiple
   maps t-SNE Matlab code by van der Maaten and Hinton (2012). \code{mmtsne}
   estimates a multidimensional array of \code{N x no_dims x no_maps}. Each
   map is an \code{N x no_dims} matrix of estimated t-SNE coordinates. When
   \code{no_maps=1}, multiple maps t-SNE reduces to standard t-SNE.
}
\examples{
# Load the iris dataset
data("iris")

# Estimate a mmtsne model with 2 maps, 2 dimensions each
model <- mmtsne(iris[,1:4], no_maps=2, max_iter=100)

# Plot the results side-by-side for inspection
# Points scaled by map proportion weights plus constant factor
par(mfrow=c(1,2))
plot(model$Y[,,1], col=iris$Species, cex=model$proportions[,1] + .2)
plot(model$Y[,,2], col=iris$Species, cex=model$proportions[,2] + .2)
par(mfrow=c(1,1))

}
\references{
L.J.P. van der Maaten and G.E. Hinton. ``Visualizing Non-Metric
   Similarities in Multiple Maps.'' \emph{Machine Learning} 87(1):33-55,
   2012.
   \href{https://lvdmaaten.github.io/publications/papers/MachLearn_2012.pdf}{PDF.}
}
