% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiLayerNet_functions.R
\name{mnda_node_distance}
\alias{mnda_node_distance}
\title{Detecting the nodes whose local neighbors change between the two conditions for ISNs.}
\usage{
mnda_node_distance(embeddingSpaceList)
}
\arguments{
\item{embeddingSpaceList}{a list obtained by the \code{mnda_embedding_2layer()} function.}
}
\value{
the distances for each repeat
}
\description{
Detecting the nodes whose local neighbors change between the two conditions for ISNs.
}
\details{
Calculating the distance of node pairs in the embedding space and check their significance.
To find the significantly varying nodes in the 2-layer-network, the distance between
the corresponding nodes are calculated along with the null distribution.
The null distribution is obtained based on the pairwise distances on null graphs.
if in \code{mnda_embedding_2layer} function \code{null.perm=FALSE}, the multiplex network
does not have the two randomly permuted graphs, thus the distances between all the nodes will
be used for the null distribution.
}
\examples{
myNet = network_gen(N_nodes = 50, N_var_nodes = 5, N_var_nei = 40, noise_sd = .01)
graph_data = myNet[["data_graph"]]
embeddingSpaceList = mnda_embedding(graph.data=graph_data, outcome=c(1,2),
indv.index=c(1,1), train.rep=2, random.walk=FALSE)
Dist = mnda_node_distance(embeddingSpaceList)

}
