% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiNormal-dist.R
\name{MultiNormal-dist}
\alias{MultiNormal-dist}
\alias{dmNorm}
\alias{rmNorm}
\alias{MultiNormal}
\title{The Multivariate Normal distribution.}
\usage{
dmNorm(x, mu, Sigma, log = FALSE)

rmNorm(n, mu, Sigma)
}
\arguments{
\item{x}{Argument to the density function.  A vector of length \code{q} or an \verb{n x q} matrix.}

\item{mu}{Mean vector(s).  Either a vector of length \code{q} or an \verb{n x q} matrix.  If missing defaults to a vector of zeros.}

\item{Sigma}{Covariance matrix or matrices.  Either a \verb{q x q} matrix or a \verb{q x q x n} array.  If missing defaults to the identity matrix.}

\item{log}{Logical; whether or not to compute the log-density.}

\item{n}{Integer number of random samples to generate.}
}
\value{
A vector for densities, or a \verb{n x q} matrix for random sampling.
}
\description{
Density and random sampling for the Multivariate Normal distribution.
}
\examples{
# Parameter specification
q <- 4 # number of dimensions
mu <- 1:q # mean vector
V <- toeplitz(exp(-seq(1:q))) # variance matrix

# Random sample
n <- 100
X <- rmNorm(n, mu, V)

# Calculate log density for each sampled vector
dmNorm(X, mu, V, log = TRUE)
}
