% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{EHS}
\alias{EHS}
\title{Statistic of the EHS test based on a multivariate Stein equation}
\usage{
EHS(data, a = 1)
}
\arguments{
\item{data}{a (d,n) numeric matrix containing the data.}

\item{a}{positive numeric number (tuning parameter).}
}
\value{
The value of the test statistic.
}
\description{
Computes the test statistic of the EHS test based on a multivariate Stein equation.
}
\details{
This functions evaluates the teststatistic with the given data and the specified tuning parameter \code{a}.
Each row of the data Matrix contains one of the n (multivariate) sample with dimension d. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error.

Note that \code{a=Inf} returns the limiting test statistic with value \code{2*\link{MSkew} + \link{MRSSkew}} and \code{a=0} returns the value of the limit statistic
\deqn{T_{n,0}=\frac{d}{2}-2^{\frac{d}{2}+1}\frac{1}{n}\sum_{j=1}^n\|Y_{n,j}\|^2\exp(-\frac{\|Y_{n,j}\|^2}{2}).}
}
\references{
Ebner, B., Henze, N., Strieder, D. (2020) "Testing normality in any dimension by Fourier methods in a multivariate Stein equation" \href{https://arxiv.org/abs/2007.02596}{arXiv:2007.02596}
}
