% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modTurPoint.R
\name{modTurPoint}
\alias{modTurPoint}
\title{Modified Turning Point Method for ED50 Estimation}
\usage{
modTurPoint(doseSeries, onlyTurPoint = FALSE, confidence = 0.95)
}
\arguments{
\item{doseSeries}{A numeric vector. It can be the whole dose sequence given in a group of
experiments in the order. And it can also be the turning point sequence calculated.}

\item{onlyTurPoint}{A logical value indicating whether the \code{doseSeries} is a turning
point sequence or not, the defaut is value is \code{FALSE}.}

\item{confidence}{A value ranging from 0 to 1 that represents the confidence level. The
default value is 0.95.}
}
\value{
A list:
\item{Estimate}{The point estimate of ED59 using modified turning point method.}
\item{Confidence}{Confidence value input.}
\item{CI.lower}{The lower bound of confidence interval under a certain confidence level.}
\item{CI.upper}{The upper bound of confidence interval under a certain confidence level.}
}
\description{
50 percent effective dose (abbreviated as ED50) is one of the most concerns
in the field of Anesthesiology. There are many methods to estimate ED50 and its confidence
interval. Turning point method is one of them proposed by Choi in 1990 and here is the
modified function to realize the ED50 estimation.
}
\examples{
library(modTurPoint)
dose1 <- c(3.1, 3.2, 3.3, 3.2, 3.1, 3.2, 3.3, 3.2, 3.3)
modTurPoint(doseSeries = dose1, confidence = 0.9)
dose2 <- c(3.25, 3.15, 3.25, 3.25)
modTurPoint(doseSeries = dose2, onlyTurPoint = TRUE, confidence = 0.9)
}
\references{
Choi SC Interval estimation of the LD50 based on an up-and-down experiment. Biometrics 1990; 46: 485-92.
}
