% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.model_set.R
\name{print.model_set}
\alias{print.model_set}
\title{Print a \code{model_set}-Class Object}
\usage{
\method{print}{model_set}(
  x,
  bic_digits = 3,
  bpp_digits = 3,
  sort_models = TRUE,
  max_models = 20,
  bpp_target = NULL,
  target_name = "original",
  more_fit_measures = c("cfi", "rmsea", "srmr"),
  fit_measures_digits = 3,
  short_names = FALSE,
  cumulative_bpp = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{model_set}-class object.}

\item{bic_digits}{The number of
decimal places to be displayed
for BIC.
Default is 3.}

\item{bpp_digits}{The number of
decimal places to be displayed
for BIC posterior probability
and prior probabilities.
Default is 3.}

\item{sort_models}{Whether the models
will be sorted by BIC posterior
probability.
Default is \code{TRUE}.}

\item{max_models}{The maximum number
of models to be printed. Default is
20.}

\item{bpp_target}{The desired
BIC probability. Used to compute
and print
the minimum prior probability
of the target model required to
achieve \code{bpp_target}. Default
is \code{NULL}.}

\item{target_name}{The name of the
target model as appeared in the
model list. Default is \code{"original"}.
Used if \code{bpp_target} is not \code{NULL}.}

\item{more_fit_measures}{Character
vector. To be passed to
\code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}. Default
is \code{c("cfi", "rmsea", "srmr")}. Set it to
\code{NULL} to disable printing additional
fit measures.}

\item{fit_measures_digits}{The number of
decimal places to be displayed
for additional fit measures, if
requested. Default is 3.}

\item{short_names}{If \code{TRUE},
then simple short names will be
printed
along with full model names.
Default is \code{FALSE}. Short names
can be used when interpreting
the graph from \code{model_graph()}
if short names are used in the graph.}

\item{cumulative_bpp}{If \code{TRUE} and
the models are sorted by BPPs,
cumulative BPPs will be printed.
Default is \code{FALSE}.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of
a \code{model_set}-class object.
}
\details{
It is the print method of the
output of \code{\link[=model_set]{model_set()}}.
}
\examples{

library(lavaan)

dat <- dat_path_model

mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"

fit <- sem(mod, dat_path_model, fixed.x = TRUE)

out <- model_set(fit)
out

}
\seealso{
A \code{model_set}-class object
is generated by \code{\link[=model_set]{model_set()}}.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
