% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{spotify_by_genre}
\alias{spotify_by_genre}
\title{Spotify by Genre Dataset}
\format{
A data frame with 6,000 rows and 21 columns:
\describe{
\item{track_id}{\code{character}. Spotify ID for the track. See: \url{https://developer.spotify.com/documentation/web-api/}}
\item{artists}{\code{character}. Names of the artists associated with the track.}
\item{album_name}{\code{character}. Name of the album on which the track appears.}
\item{track_name}{\code{character}. Name of the track.}
\item{popularity}{\code{numeric}. Popularity score of the track (0-100). See: \url{https://developer.spotify.com/documentation/web-api/reference/#/operations/get-track}}
\item{duration_ms}{\code{numeric}. Duration of the track in milliseconds.}
\item{explicit}{\code{logical}. Whether the track has explicit content.}
\item{danceability}{\code{numeric}. Danceability score of the track (0-1). See: \url{https://developer.spotify.com/documentation/web-api/reference/#/operations/get-audio-features}}
\item{energy}{\code{numeric}. Energy score of the track (0-1).}
\item{key}{\code{numeric}. The key the track is in (0-11 where 0 = C, 1 = C#/Db, etc.).}
\item{loudness}{\code{numeric}. The loudness of the track in decibels (dB).}
\item{mode}{\code{numeric}. Modality of the track (0 = minor, 1 = major).}
\item{speechiness}{\code{numeric}. Speechiness score of the track (0-1).}
\item{acousticness}{\code{numeric}. Acousticness score of the track (0-1).}
\item{instrumentalness}{\code{numeric}. Instrumentalness score of the track (0-1).}
\item{liveness}{\code{numeric}. Liveness score of the track (0-1).}
\item{valence}{\code{numeric}. Valence score of the track (0-1), indicating the musical positiveness.}
\item{tempo}{\code{numeric}. Tempo of the track in beats per minute (BPM).}
\item{time_signature}{\code{numeric}. Time signature of the track (typically 3, 4, or 5).}
\item{track_genre}{\code{character}. Genre of the track (country, deep-house, dubstep, hip-hop, metal, and rock).}
\item{popular_or_not}{\code{character}. Indicates whether the track is considered popular ("popular") or not ("not popular"). Popularity is defined as a score of 50 or higher which corresponds to the 75th percentile of the \code{popularity} column.}
}
}
\source{
\url{https://developer.spotify.com/documentation/web-api/}
}
\usage{
spotify_by_genre
}
\description{
This dataset contains information on 6,000 tracks from Spotify, categorized by one of six genres. It includes various audio features, metadata about the tracks, and an indicator of popularity. The dataset is useful for analysis of music trends, popularity prediction, and genre-specific characteristics.
}
\examples{
data(spotify_by_genre)
head(spotify_by_genre)
}
\keyword{datasets}
