% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SURfunctions.R
\name{SURfit}
\alias{SURfit}
\title{Fit SUR models with or without constraints}
\usage{
SURfit(
  data,
  varMods = NULL,
  mod = "min",
  maxiter = 100,
  m = NULL,
  type = "g",
  center = TRUE,
  scale = FALSE,
  exogenous = TRUE,
  covs = NULL,
  sur = TRUE,
  consec = NULL,
  ...
)
}
\arguments{
\item{data}{Dataframe or matrix containing idiographic temporal data.}

\item{varMods}{Output of \code{\link{varSelect}} or \code{\link{modSelect}}.
The latter must be applied to \code{\link{resample}} results in order for
it to work as input for this argument.}

\item{mod}{Character string. Only applies if output from
\code{\link{varSelect}} or \code{\link{modSelect}} is used to constrain the
model, and cross-validation \code{"CV"} was set as the criterion for
model/variable selection. Options include \code{"min"}, which uses the
lambda value that minimizes the objective function, or \code{"1se"} which
uses the lambda value at 1 standard error above the value that minimizes
the objective function.}

\item{maxiter}{Numeric. The maximum number of iterations to attempt before
stopping the function.}

\item{m}{Character string or numeric value to specify the moderator (if any).}

\item{type}{Indicates the type of model to use, either \code{"g"} for
gaussian, or \code{"c"} for categorical (i.e., binary, at present). This
argument should not be edited by the user, as the appropriate input will
automatically be detected.}

\item{center}{Logical. Determines whether to mean-center the variables.}

\item{scale}{Logical. Determines whether to standardize the variables.}

\item{exogenous}{Logical. See \code{\link{fitNetwork}} function for details.}

\item{covs}{something}

\item{sur}{Logical. Provides input to the \code{method} argument of the
\code{\link[systemfit:systemfit]{systemfit::systemfit}} function. If
\code{TRUE}, then the \code{method} will be \code{"SUR"}. If \code{FALSE},
then the \code{method} will be \code{"OLS"}. These two methods only differ
when constraints are applied. When a saturated model is fit, both methods
produce the same results.}

\item{consec}{A logical vector that identifies which values to include in
accordance with the \code{beepno} and \code{dayno} arguments in the
\code{\link{fitNetwork}} function.}

\item{...}{Additional arguments.}
}
\value{
A SUR model, as fit with the
\code{\link[systemfit:systemfit]{systemfit::systemfit}} function.
}
\description{
A wrapper for the \code{\link[systemfit:systemfit]{systemfit::systemfit}}
function that will construct formulas for all equations based on specified
moderators. This function was NOT designed for user-level functionality, but
rather exists to be embedded within \code{\link{fitNetwork}}. The purpose for
making it available to the user is for allowing the exact fitted model to be
highly customizable.
}
\details{
See the \code{systemfit} package for details on customizing
\code{\link[systemfit:systemfit]{systemfit::systemfit}} objects. Constraints
can be applied via the \code{varMods} argument, which is intended to
facilitate the output of the \code{\link{varSelect}} and
\code{\link{resample}} functions. These objects can be further edited to
apply constraints not specified by these automated functions. Moreover, there
are a variety of additional arguments that can be supplied to the
\code{\link[systemfit:systemfit]{systemfit::systemfit}} function if desired.

If the variable selection results from \code{\link{resample}} are intended to
be used as input for the \code{varMods} argument, then these results must be
fed into the \code{\link{modSelect}} function.
}
\seealso{
\code{\link{SURnet}, \link{fitNetwork},
  \link[systemfit:systemfit]{systemfit::systemfit}}
}
