% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bfiDat}
\alias{bfiDat}
\title{bfi data}
\format{
A data frame with six variables representing composite scores
forparticipants across the Big 5 personality dimensions as well as gender.
\code{A} is Agreeableness, \code{C} is conscientiousness, \code{E} is
extraversion, \code{N} is neuroticism, and \code{O} is openness to
experience. For a given participant, each value represents the mean of 5
self report items from the associated scale. Response values range from
\code{0} to \code{6}. In total, 7 negatively-worded items were reverse
scored before calculating scale composites. \code{gender} is a binary
variable coded such that \code{0 = Males}, and \code{1 = Females}.
}
\source{
The items are from the IPIP (Goldberg, 1999). The data are from the
SAPA project (Revelle, Wilt and Rosenthal, 2010) , collected Spring, 2010 (
https://www.sapa-project.org/).
}
\usage{
bfiDat
}
\description{
Composite scores on the Big 5 personality dimensions and gender. Adapted from
the \code{bfi} data in the \code{psychTools} package.
}
\references{
Goldberg, L.R. (1999) A broad-bandwidth, public domain, personality inventory
measuring the lower-level facets of several five-factor models. In Mervielde,
I. and Deary, I. and De Fruyt, F. and Ostendorf, F. (eds) Personality
psychology in Europe. 7. Tilburg University Press. Tilburg, The Netherlands.

Revelle, W., Wilt, J., and Rosenthal, A. (2010) Individual Differences in
Cognition: New Methods for examining the Personality-Cognition Link In
Gruszka, A. and Matthews, G. and Szymura, B. (Eds.) Handbook of Individual
Differences in Cognition: Attention, Memory and Executive Control, Springer.
}
\keyword{datasets}
