% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootNet.R
\name{bootNetDescriptives}
\alias{bootNetDescriptives}
\alias{summary.bootNet}
\alias{cscoef}
\title{Descriptive statistics for \code{\link{bootNet}} objects}
\usage{
\method{summary}{bootNet}(object, centrality = TRUE, ...)

cscoef(object, cor = 0.7, ci = 0.95, first = TRUE, verbose = TRUE)
}
\arguments{
\item{object}{\code{\link{bootNet}} output}

\item{centrality}{Logical. Determines whether or not strength centrality and
expected influence should be computed for output.}

\item{...}{Additional arguments.}

\item{cor}{Numeric value to indicate the correlation stability value to be
computed.}

\item{ci}{Numeric. Confidence interval level for CS coefficient.}

\item{first}{Logical. Whether or not to count the first instance that a CS
statistic dips below the requisite threshold. Often times the value of this
will not affect the results. When it does, if \code{first = TRUE} then the
calculation will be more conservative.}

\item{verbose}{Logical. Whether to write out the full statement of the CS
coefficient in output. Set to \code{FALSE} if you want the details about
the CS coefficient saved as attributes on the output.}
}
\value{
A table of descriptives for \code{\link{bootNet}} objects, or
correlation-stability coefficients for the case-drop bootstrap.
}
\description{
Currently only works for GGMs, including the between-subjects network
returned in the \code{\link{mlGVAR}} output.
}
\details{
Outputs correlation-stability (CS) coefficients for the case-drop bootstrap.
}
\examples{
\donttest{
boot1 <- bootNet(ggmDat, 'M')
summary(boot1)

boot2 <- bootNet(gvarDat, 'M', lags = 1)

mod1 <- varSelect(gvarDat, 'M', lags = 1)
boot3 <- bootNet(gvarDat, 'M', lags = 1, type = mod1, caseDrop = TRUE)
summary(boot3)
}
}
\seealso{
\code{\link{bootNet}}
}
