% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.R
\name{net}
\alias{net}
\alias{netInts}
\title{Get adjacency matrices from fit objects}
\usage{
net(
  fit,
  n = "beta",
  threshold = FALSE,
  rule = "OR",
  binary = FALSE,
  nodewise = FALSE,
  d = 14,
  r = NULL
)

netInts(
  fit,
  n = "temporal",
  threshold = FALSE,
  avg = FALSE,
  rule = "none",
  r = NULL,
  empty = TRUE,
  mselect = NULL
)
}
\arguments{
\item{fit}{A fitted network model. Can be the output from
\code{\link{fitNetwork}}, \code{\link{mlGVAR}}, \code{\link{lmerVAR}},
\code{\link{bootNet}}, \code{\link{resample}}, \code{\link{simNet}}, or
\code{\link{mlGVARsim}}.}

\item{n}{When multiple networks exist for a single object, this allows the
user to indicate which adjacency matrix to return. For a GGM, all values of
this argument return the same adjacency matrix. For a SUR network,
\code{"beta"} and \code{"temporal"} return the coefficients associated with
the temporal network, while \code{"pdc"} returns the Partial Directed
Correlations, or the standardized temporal network.
\code{"contemporaneous"} and \code{"pcc"} return the standardized
contemporaneous network (Partial Contemporaneous Correlations).
\code{"kappa"} returns the unstandardized residual covariance matrix. All
of these terms apply for multilevel networks, but \code{"between"} can also
return the between-subjects network. If a numeric or logical value is
supplied, however, this argument will function as the \code{threshold}
argument. A numeric value will set a threshold at the supplied value, while
\code{TRUE} will set a threshold of .05.}

\item{threshold}{A numeric or logical value to set a p-value threshold.
\code{TRUE} will automatically set the threshold at .05.}

\item{rule}{Only applies to GGMs (including between-subjects networks) when a
threshold is supplied. The \code{"AND"} rule will only preserve edges when
both corresponding coefficients have p-values below the threshold, while
the \code{"OR"} rule will preserve an edge so long as one of the two
coefficients have a p-value below the supplied threshold.}

\item{binary}{Logical. If \code{TRUE} then the weighted adjacency matrix will
be converted into an unweighted adjacency matrix.}

\item{nodewise}{Logical, only applies to GGMs (including between-subjects
networks). If \code{TRUE} then the adjacency matrix will retain all
coefficients in their original form. In this case, values in rows represent
the coefficients predicting the columns.}

\item{d}{Numeric. Only used for output of \code{\link{mlGVARsim}}, or
\code{\link{simNet}} when \code{lags = 1}. Sets the number of decimal
places to round the output to.}

\item{r}{Numeric. Chooses which rows/columns to remove from the output, if
desired.}

\item{avg}{Logical. For \code{\link{netInts}}, determines whether to take the
average two corresponding interaction terms.}

\item{empty}{Logical. Determines the output of \code{\link{netInts}} when
\code{fit} is not a moderated network. If \code{TRUE} then an empty list
will be returned. If \code{FALSE} then a matrix of zeros will be returned.}

\item{mselect}{Only used for \code{\link{netInts}} when there is more than
one exogenous moderator. Allows the user to indicate which moderator should
be used to construct the interaction matrix.}
}
\value{
An adjacency matrix representing a network or a matrix of interaction
terms.
}
\description{
\code{\link{net}} returns the adjacency matrix for any network model fit
using functions from the \code{modnets} package. \code{\link{netInts}}
returns a matrix of interaction terms associated with a moderated network.
}
\details{
For GGMs when a non-symmetric matrix is requested, columns will represent
outcomes and rows will represent predictors. For temporal networks, columns
represent predictors and rows represent outcomes.

Can also be used with output from the \code{\link{resample}} and
\code{\link{bootNet}} functions.
}
\examples{
x <- fitNetwork(ggmDat, 'M')

net(x, threshold = .05)
netInts(x, threshold = TRUE)

\donttest{
y <- mlGVAR(mlgvarDat, 'M')

net(y, n = 'beta')
net(y, n = 'pcc')
net(y, n = 'between')

netInts(y)
}
}
\seealso{
\code{\link{fitNetwork}, \link{mlGVAR}, \link{lmerVAR},
  \link{bootNet}, \link{resample}, \link{simNet}, \link{mlGVARsim}}
}
