% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotMods}
\alias{plotMods}
\title{Plot conditional networks at different levels of the moderator}
\usage{
plotMods(
  nets,
  nodewise = FALSE,
  elsize = 2,
  vsize = NULL,
  elabs = TRUE,
  predict = NULL,
  layout = NULL,
  which.net = "temporal",
  ...
)
}
\arguments{
\item{nets}{List of network models fit with \code{\link{fitNetwork}}, where
\code{mval} has been specified.}

\item{nodewise}{See corresponding argument in \code{\link{plotNet}}.}

\item{elsize}{Numeric value to indicate the size of the edge labels.}

\item{vsize}{Numeric value to indicate the size of the nodes. If \code{NULL},
then a default value will be determined based on the number of nodes in the
network.}

\item{elabs}{If \code{TRUE}, then edges will be labeled with their numeric
values.}

\item{predict}{See corresponding argument in \code{\link{plotNet}}.}

\item{layout}{Can be a character string, corresponding to the options in
\code{\link[qgraph:qgraph]{qgraph::qgraph}}, or can be a matrix that
defines the layout (e.g., based on the
\code{\link[qgraph:averageLayout]{qgraph::averageLayout}} function).
Recommended to leave as \code{NULL}, so that the layout will be based on
the list of networks provided.}

\item{which.net}{See corresponding argument in \code{\link{plotNet}}.}

\item{...}{Additional arguments.}
}
\value{
Returns a plot where multiple conditional networks are plotted side
by side.
}
\description{
An easy wrapper for plotting the same network at different levels of a
moderator. Using the \code{mval} argument of the \code{\link{fitNetwork}}
function, you can create multiple models---conditional networks---wherein the
same model is fit at different values of the moderator.
}
\details{
Importantly, this function will fix a common layout across all conditional
networks so that the network can be easily compared (visually) at different
levels of the moderator.
}
\examples{
data <- na.omit(psychTools::msq[, c('hostile', 'lonely', 'nervous', 'sleepy', 'depressed')])

fit0 <- fitNetwork(data, moderators = 'depressed', mval = 0)
fit1 <- fitNetwork(data, moderators = 'depressed', mval = 1)
fit2 <- fitNetwork(data, moderators = 'depressed', mval = 2)

fits <- list(fit0, fit1, fit2)
plotMods(fits)
}
\seealso{
\code{\link{fitNetwork}}
}
