% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-SurvFitCstExp.R,
%   R/predict-SurvFitVarExp.R, R/predict.R
\name{PredictSurvFit}
\alias{PredictSurvFit}
\alias{predict_SurvFitCstExp}
\alias{predict_cstSD}
\alias{predict_cstIT}
\alias{predict_SurvFitVarExp}
\alias{predict_varSD}
\alias{predict_varIT}
\alias{predict}
\alias{predict.SurvFit}
\title{Prediction base on \code{SurvFit} objects}
\usage{
predict_SurvFitCstExp(
  fit,
  display.exposure = NULL,
  hb_value = NULL,
  interpolate_length = NULL,
  ...
)

predict_cstSD(
  display.exposure = NULL,
  display.parameters = NULL,
  hb_value = NULL,
  interpolate_length = NULL
)

predict_cstIT(
  display.exposure = NULL,
  display.parameters = NULL,
  hb_value = NULL,
  interpolate_length = NULL
)

predict_SurvFitVarExp(
  fit,
  display.exposure = NULL,
  hb_value = NULL,
  interpolate_length = NULL,
  interpolate_method = "linear",
  ...
)

predict_varSD(
  display.exposure = NULL,
  display.parameters = NULL,
  hb_value = NULL,
  interpolate_length = NULL,
  interpolate_method = NULL
)

predict_varIT(
  display.exposure = NULL,
  display.parameters = NULL,
  hb_value = NULL,
  interpolate_length = NULL,
  interpolate_method = NULL
)

predict(fit, ...)

\method{predict}{SurvFit}(
  fit,
  display.exposure = NULL,
  hb_value = NULL,
  interpolate_length = NULL,
  interpolate_method = "linear",
  ...
)
}
\arguments{
\item{fit}{an object of class \code{SurvFit}}

\item{display.exposure}{concentration points on which prediction is done}

\item{hb_value}{a numeric used as \code{hb_value} (can be set to 0 to remove
background mortality and take only effect parameters).}

\item{interpolate_length}{if \code{display.time} is \code{NULL}, the argument
\code{interpolate_length} can be used to provide a sequence from 0 to maximum of
the time of exposure in original dataset (used for fitting).}

\item{\dots}{Further arguments to be passed to generic methods}

\item{display.parameters}{parameters of the specific model.}

\item{interpolate_method}{The interpolation method for concentration.
See package \code{deSolve} for details.
Default is \code{linear}.}
}
\value{
a \code{list} of \code{data.frame} with the quantiles of outputs in
\code{df_quantiles} or all the MCMC chains \code{df_spaghetti}
}
\description{
This is the generic \code{predict} S3 method for the \code{SurvFit} class.
It provides predicted survival rate for "SD" or "IT" models under constant or time-variable exposure.
prediction on constant exposure profile

Note: On constant exposure profiles, the results is explicit (exact), so you
don't have to profile
}
