test_that("SurvMODEL_cst", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    # SD
    morseTKTD:::SurvSD_cst(Cw = 8,
               time = 0:14,
               kd = 0.7240413,
               hb = 0.01726652,
               z = 16.89198,
               kk = 0.1262929,
               interpolate_length = NULL)
    morseTKTD:::SurvSD_cst(Cw = 8,
                           time = 14,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           z = 16.89198,
                           kk = 0.1262929,
                           interpolate_length = NULL)
    morseTKTD:::SurvSD_cst(Cw = 8,
                           time = 0:14,
                           kd = rep(0.7240413,3),
                           hb = rep(0.01726652,3),
                           z = rep(16.89198,3),
                           kk = rep(0.1262929,3),
                           interpolate_length = NULL)
    morseTKTD:::SurvSD_cst(Cw = 8,
                           time = 14,
                           kd = rep(0.7240413,3),
                           hb = rep(0.01726652,3),
                           z = rep(16.89198,3),
                           kk = rep(0.1262929,3),
                           interpolate_length = NULL)
    morseTKTD:::SurvSD_cst(Cw = 0,
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           z = 16.89198,
                           kk = 0.1262929,
                           interpolate_length = 100)
    
    # IT
    morseTKTD:::SurvIT_cst(Cw = 0,
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           alpha = 17.70611,
                           beta = 6.761304,
                           interpolate_length = NULL)
    morseTKTD:::SurvIT_cst(Cw = 0,
                           time = 4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           alpha = 17.70611,
                           beta = 6.761304,
                           interpolate_length = NULL)
    morseTKTD:::SurvIT_cst(Cw = 0,
                           time = 0:4,
                           kd = rep(0.7240413,3),
                           hb = rep(0.01726652,3),
                           alpha = rep(17.70611,3),
                           beta = rep(6.761304,3),
                           interpolate_length = NULL)
    morseTKTD:::SurvIT_cst(Cw = 0,
                           time = 4,
                           kd = rep(0.7240413,3),
                           hb = rep(0.01726652,3),
                           alpha = rep(17.70611,3),
                           beta = rep(6.761304,3),
                           interpolate_length = NULL)
    morseTKTD:::SurvIT_cst(Cw = 0,
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           alpha = 17.70611,
                           beta = 6.761304,
                           interpolate_length = 0)
    morseTKTD:::SurvIT_cst(Cw = 0,
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           alpha = 17.70611,
                           beta = 6.761304,
                           interpolate_length = 100)
    
})

test_that("Predict_cst", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    interpolate_length = NULL
    df.exp = data.frame(conc = 5, time = 0:4, replicate = 1)
    # SD
    df.par = data.frame(kd = 0.7240413,
                        hb = 0.01726652,
                        z = 16.89198,
                        kk = 0.1262929)
    morseTKTD:::predict_cstSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
    df.exp = data.frame(conc = 5, time = 14, replicate = 1)
    morseTKTD:::predict_cstSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
    df.exp = data.frame(conc = 5, time = 0:4, replicate = 1)
    df.par = data.frame(kd = rep(0.7240413, 3),
                        hb = rep(0.01726652, 3),
                        z = rep(16.89198, 3),
                        kk = rep(0.1262929, 3))
    morseTKTD:::predict_cstSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
    df.exp = data.frame(conc = 5, time = 14, replicate = 1)
    morseTKTD:::predict_cstSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
    # IT
    df.exp = data.frame(conc = 5, time = 0:4, replicate = 1)
    df.par = data.frame(kd = 0.7240413,
                        hb = 0.01726652,
                        alpha = 17.70611,
                        beta = 6.761304)
    morseTKTD:::predict_cstIT(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
    df.exp = data.frame(conc = 5, time = 14, replicate = 1)
    morseTKTD:::predict_cstSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
    df.par = data.frame(kd = rep(0.7240413, 3),
                        hb = rep(0.01726652, 3),
                        alpha = rep(17.70611, 3),
                        beta = rep(6.761304, 3))
    morseTKTD:::predict_cstIT(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
    df.exp = data.frame(conc = 5, time = 14, replicate = 1)
    morseTKTD:::predict_cstSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length)
})


test_that("CstExpSurvFit", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))

    # IT
    
    
    cPRZ_ITpred <- predict(cPRZ_ITfit)
    cPRZ_ITpred100 <- predict(cPRZ_ITfit, interpolate_length = 100)
    cPRZ_ITpred_1 <- predict(cPRZ_ITfit, display.exposure = data.frame(
        conc = 5,
        time = 0:9,
        replicate = 1
    ))
    cPRZ_ITpred_2 <- predict(cPRZ_ITfit, display.exposure = data.frame(
        conc = c(rep(0,10),rep(5,10)),
        time = rep(0:9,2),
        replicate = c(rep(1,10),rep(2,10))
    ))
    
    #SD
    cPRZ_SDpred <- predict(cPRZ_SDfit)
    cPRZ_SDpred100 <- predict(cPRZ_SDfit, interpolate_length = 100)
    cPRZ_SDpred_1 <- predict(cPRZ_SDfit, display.exposure = data.frame(
        conc = 5,
        time = 1:10,
        replicate = 1
    ))
    cPRZ_SDpred_2 <- predict(cPRZ_SDfit, display.exposure = data.frame(
        conc = c(rep(0,10), rep(5,10)),
        time = rep(0:9,2),
        replicate = c(rep(1,10), rep(2,10))
    ))
    plot(cPRZ_SDpred100)

})
################################################################################

test_that("SurvMODEL_var", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    # SD
    morseTKTD:::SurvSD_var(Cw = c(10,0,5,3,10),
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           z = 16.89198,
                           kk = 0.1262929,
                           interpolate_length = NULL,
                           interpolate_method = "linear")
    morseTKTD:::SurvSD_var(Cw = c(10,0,5,3,10),
                           time = 0:4,
                           kd = rep(0.7240413,3),
                           hb = rep(0.01726652,3),
                           z = rep(16.89198,3),
                           kk = rep(0.1262929,3),
                           interpolate_length = NULL,
                           interpolate_method = "linear")
    morseTKTD:::SurvSD_var(Cw = c(10,0,5,3,10),
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           z = 16.89198,
                           kk = 0.1262929,
                           interpolate_length = 100,
                           interpolate_method = "linear")
    
    # IT
    morseTKTD:::SurvIT_var(Cw = c(10,0,5,3,10),
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           alpha = 17.70611,
                           beta = 6.761304,
                           interpolate_length = NULL,
                           interpolate_method = "linear")
    morseTKTD:::SurvIT_var(Cw = c(10,0,5,3,10),
                           time = 0:4,
                           kd = rep(0.7240413,3),
                           hb = rep(0.01726652,3),
                           alpha = rep(17.70611,3),
                           beta = rep(6.761304,3),
                           interpolate_length = NULL,
                           interpolate_method = "linear")
    morseTKTD:::SurvIT_var(Cw = 0,
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           alpha = 17.70611,
                           beta = 6.761304,
                           interpolate_length = 0,
                           interpolate_method = "linear")
    morseTKTD:::SurvIT_var(Cw = 0,
                           time = 0:4,
                           kd = 0.7240413,
                           hb = 0.01726652,
                           alpha = 17.70611,
                           beta = 6.761304,
                           interpolate_length = 100,
                           interpolate_method = "linear")
    
})

test_that("Predict_var", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    interpolate_length = NULL
    df.exp = data.frame(conc = c(10,0,5,3,10), time = 0:4, replicate = 1)
    # SD
    df.par = data.frame(kd = 0.7240413,
                        hb = 0.01726652,
                        z = 16.89198,
                        kk = 0.1262929)
    predict_varSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length,
                  interpolate_method = "linear")
    n = 15e3
    df.par = data.frame(kd = rep(0.7240413, n),
                        hb = rep(0.01726652, n),
                        z = rep(16.89198, n),
                        kk = rep(0.1262929, n))
    
    start_time <- Sys.time()
    a = predict_varSD(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length,
                  interpolate_method = "linear")
    end_time <- Sys.time()
    end_time - start_time
    # IT
    df.par = data.frame(kd = 0.7240413,
                        hb = 0.01726652,
                        alpha = 17.70611,
                        beta = 6.761304)
    predict_varIT(display.exposure = df.exp,
                  display.parameters = df.par,
                  interpolate_length = interpolate_length,
                  interpolate_method = "linear")
    n = 15e3
    df.par = data.frame(kd = rep(0.7240413, n),
                        hb = rep(0.01726652, n),
                        alpha = rep(17.70611, n),
                        beta = rep(6.761304, n))
    start_time <- Sys.time()
    a = predict_varIT(display.exposure = df.exp,
                      display.parameters = df.par,
                      interpolate_length = interpolate_length,
                      interpolate_method = "linear")
    end_time <- Sys.time()
    end_time - start_time
})

test_that("VarExpSurvFit", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    
    # SD
    df.exp = data.frame(conc = c(10,0,5,3,10), time = 0:4, replicate = 1)
    vPRZ_SDpredX <- predict(vPRZ_SDfit, display.exposure = df.exp)
   
    df.exp = data.frame(conc = rep(c(10,0,5,3,10), 11), time = 0:54, replicate = 1)
    vPRZ_SDpredX <- predict(vPRZ_SDfit, display.exposure = df.exp)
    
    df.exp = data.frame(conc = rep(c(10,0,5,3,10), 5),
                        time = rep(0:4, 5),
                        replicate = rep(1:5, each = 5))
    
    vPRZ_SDpredX <- predict(vPRZ_SDfit, display.exposure = df.exp)
    df.exp = data.frame(
        conc = rep(0,11),
        time = 0:10,
        replicate = 1)
    vPRZ_SDpredX <- predict(vPRZ_SDfit, display.exposure = df.exp)
    
    # IT
    vPRZ_ITpredX <- predict(vPRZ_ITfit, display.exposure = df.exp)
    vPRZ_ITpred <- predict(vPRZ_ITfit)
    vPRZ_ITpred100 <- predict(vPRZ_ITfit, interpolate_length = 100)
    
})

