% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/review.R
\name{review}
\alias{review}
\title{Review previously identified mortalities using new data}
\usage{
review(
  morts,
  new.data,
  old.data = NULL,
  type,
  ID,
  station,
  res.start = "auto",
  res.end = NULL,
  residences = NULL,
  units = NULL,
  ddd = NULL,
  from.station = NULL,
  to.station = NULL,
  verbose = TRUE
)
}
\arguments{
\item{morts}{a dataframe with previously flagged mortalities. Format does
not need to match \code{new.data} exactly, but the names and formats of \code{ID}, \code{station},
and \code{res.start} fields must match in all input dataframes.}

\item{new.data}{a dataframe of new residence events (i.e., generated from
detection data that were not included in earlier \code{mort} analyses).}

\item{old.data}{optional dataframe of residence events that were used
in earlier \code{mort} analyses. If \code{drift} was applied in earlier analyses,
including \code{old.data} is recommended to avoid falsely identifying station
changes.}

\item{type}{the method used to generate the residence events. Options are
"mort", "actel", "glatos", "vtrack", or "manual". If "manual", then user
must specify \code{ID}, \code{station}, \code{res.start}, \code{res.end}, \code{residences}, and \code{units}.}

\item{ID}{a string of the name of the column in \code{morts} and \code{new.data} that
holds the tag or sample IDs.}

\item{station}{a string of the name of the column in \code{morts} and \code{new.data}
that holds the station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{morts} and \code{new.data}
that holds the start date and time. Must be specified and in POSIXt or
character in the format YYYY-mm-dd HH:MM:SS.}

\item{res.end}{an optional string of the name of the column in \code{morts} and \verb{new data}
that holds the end date and time. Only needed if drift is applied.}

\item{residences}{an optional character string with the name of the column
in \code{morts} and \code{new.data} that holds the duration of the residence events.
Only needed if drift is applied.}

\item{units}{optional units of the duration of the residence events in
\code{morts} and \code{new.data}. Only needed if drift is applied.}

\item{ddd}{a dataframe of stations/locations where detected movement between
stations may be due to drifting of an expelled tag or dead animal.}

\item{from.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may start from. Must
be identical to the station/location names in \code{morts} and \code{new.data}.}

\item{to.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may move to. Must
be identical to the station/location names in \code{morts} and \code{new.data}.}

\item{verbose}{option to display progress bar as function and called
functions are run. Default is TRUE.}
}
\value{
A dataframe with one row for each tag ID from \code{morts}
with a station/location change that was identified
in \code{new.data}. The remaining fields will include the information for the
residence event that was identified as the station change, so the station
change can be verified by the user before removing the animal from \code{morts}.
All input data fields (e.g., any name, location, or species information
that was included with the input data) will be retained.
}
\description{
Uses new data to determine if an animal that was previously
flagged as a mortality made a station/location change and may therefore be
alive.
}
\examples{
morts<-morts(data=events,type="mort",ID="ID",station="Station.Name",
method="any",verbose=FALSE)

undead<-review(morts=morts,new.data=new.data,
type="mort",ID="ID",station="Station.Name",verbose=FALSE)
}
