% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_crosses.R
\name{point_crosses}
\alias{point_crosses}
\title{Number of times a point is crossed}
\usage{
point_crosses(numeric_vector, relevant_point = 0)
}
\arguments{
\item{numeric_vector}{Numbers, ordered by their time of appearance.}

\item{relevant_point}{Number which has to be crossed.}
}
\value{
Number of times that \code{numeric_vector} crosses
the \code{relevant_point} (0 to +Inf).
}
\description{
Checks how often a number (\code{relevant_point}) is being
crossed by an number sequence (\code{numeric_vector}).
}
\details{
The supplied vectors are assumed to be ordered by time.
}
\examples{
x_vals <- c(-1, 1, -1, 1, -1, 1)
point_crosses(x_vals, 0)
point_crosses(x_vals, 1)
point_crosses(x_vals, -1)

}
\references{
Wirth, R., Foerster, A., Kunde, W., & Pfister, R. (2020).
Design choices: Empirical recommendations for designing two-dimensional
finger tracking experiments. Behavior Research Methods, 52, 2394 - 2416.
\doi{10.3758/s13428-020-01409-0}
}
