% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampen.R
\name{sampen}
\alias{sampen}
\title{Sample entropy}
\usage{
sampen(
  timeseries_array,
  dimensions = 2,
  tolerance = 0.2,
  standardize = TRUE,
  use_diff = FALSE
)
}
\arguments{
\item{timeseries_array}{Array of numbers over which the sampen is to be
computed.}

\item{dimensions}{Number of embedding dimensions for which to compute the
sampen. Sometimes also called "template length".}

\item{tolerance}{Tolerance for the comparisons of two number sequences.}

\item{standardize}{Whether to standardize the timeseries_array.}

\item{use_diff}{Whether to use the differences between adjacent points.}
}
\value{
Single number indicating the sampen for the given parameters
(0 to +Inf).
}
\description{
Computes the sample entropy (sampen), as given by
Richman & Moorman (2000), \doi{10.1152/ajpheart.2000.278.6.H2039}.
}
\details{
As suggested by Richman & Moorman (2000),
\doi{10.1152/ajpheart.2000.278.6.H2039}, the last possible vector of length
\code{dimensions} is not considered because it has no corresponding vector of
length \code{dimensions + 1}, ensuring a sampen estimation with a low bias
introduced by the length of the \code{timeseries_array}.
The function was deliberately implemented in R with C-style code. While this
makes the function rather slow for large \code{timeseries_array}s,
it enables maximal transparency. For an overview over faster sampen
functions in R that, however, are distributed in binary or need source
compilation, see Chen et al. (2019), \doi{10.1093/biomethods/bpz016}.
}
\examples{
x_vals <- rep(c(0, 0, 0, 0, 0, 1), 20)
sampen(x_vals, dimensions = 1, tolerance = 1 / 2, standardize = FALSE)
sampen(x_vals, dimensions = 3, tolerance = 1 / 2, standardize = FALSE)
sampen(x_vals,
  dimensions = 3, tolerance = 1 / 2, standardize = FALSE,
  use_diff = TRUE
)
sampen(x_vals, dimensions = 3, tolerance = 1, standardize = FALSE)

}
\references{
Wirth, R., Foerster, A., Kunde, W., & Pfister, R. (2020).
Design choices: Empirical recommendations for designing two-dimensional
finger tracking experiments. Behavior Research Methods, 52, 2394 - 2416.
\doi{10.3758/s13428-020-01409-0}
}
