% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_barrier_cs.R
\name{create_barrier_cs}
\alias{create_barrier_cs}
\title{Create barrier cost surface}
\usage{
create_barrier_cs(raster, barrier, neighbours = 16, field = 0, background = 1)
}
\arguments{
\item{raster}{RasterLayer (raster package). The Resolution, Extent, and Spatial Reference System of the provided RasterLayer is used when creating the resultant Barrier Cost Surface.}

\item{barrier}{Spatial* (sp package) or RasterLayer (raster package). Area within the landscape that movement is inhibited.}

\item{neighbours}{Number of directions used in the Least Cost Path calculation.}

\item{field}{Value assigned to cells that coincide with the barrier Spatial* or RasterLayer object. Default is numeric value 0.}

\item{background}{Value assigned to cells that do not coincide with the Spatial* or RasterLayer object. Default is numeric value 1.}
}
\value{
TransitionLayer (gdistance package) numerically expressing the barriers to movement in the landscape.
The resultant TransitionLayer can be incorporated with other TransitionLayer through Raster calculations.
}
\description{
Creates a cost surface that incorporates barriers that inhibit movement in the landscape.\cr
}
\details{
The resultant Barrier Cost Surface is produced by assessing which areas of the raster
coincide with the Spatial* or RasterLayer object as specified in the barrier argument.
The areas of the raster that coincide with the barrier are given a conductance value of 0
(default value, with all other areas given a Conductance value of 1 (default value).
The conductance value of 0 ensures that movement is inhibited within these areas.
Examples of use include rivers, altitudes, and taboo areas.
If a RasterLayer object is supplied in the barrier argument then all cells with a value NOT NA will be
used as the barrier. \cr
}
\keyword{internal}
