% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{summary_onsets}
\alias{summary_onsets}
\title{Summary of difference in onsets}
\usage{
summary_onsets(
  onset_obj,
  recording,
  instruments,
  splicing_dfr = NULL,
  expr = NULL,
  show_plot = FALSE,
  filter_pair = NULL,
  na_omit = TRUE,
  time_breaks = NULL
)
}
\arguments{
\item{onset_obj}{\code{OnsetsSelected} object.}

\item{recording}{\code{Recording} object.}

\item{instruments}{character vector of instrument names.}

\item{splicing_dfr}{\code{Splice} object}

\item{expr}{R expression to subset onsetsSelected}

\item{show_plot}{show a plot? (Default is FALSE).}

\item{filter_pair}{regular expression to filter instrument pair names.}

\item{na_omit}{omit NAs (Default is TRUE).}

\item{time_breaks}{suggests the number of major time tick marks (default is NULL).}
}
\value{
a summary data frame of onset difference statistics.
}
\description{
Summary of difference in onsets
}
\examples{
r1 <- get_sample_recording()
o1 <- get_onsets_selected_data(r1)
d1 <- get_duration_annotation_data(r1)
splice_dfr <- splice_time(d1, tier = 'FORM')
summary_onsets(o1, r1, instruments = c('Inst', 'Tabla'),
  splicing_dfr = splice_dfr, show_plot = TRUE)
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_column_spliceview}()},
\code{\link{apply_segment_spliceview}()},
\code{\link{ave_cross_power_over_splices}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_cross_power1}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{compare_avg_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_gap_splice}()},
\code{\link{sample_offset_splice}()},
\code{\link{visualise_sample_splices}()}
}
\concept{statistical and analysis functions}
