% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plmp.R
\name{plmp}
\alias{plmp}
\title{Part-Linear Multidimensional Projection}
\usage{
plmp(X, sample.indices = NULL, Ys = NULL, k = 2)
}
\arguments{
\item{X}{A dataframe or matrix representing the data.}

\item{sample.indices}{The indices of subsamples used as control points.}

\item{Ys}{The control points.}

\item{k}{The target dimensionality.}
}
\value{
The low-dimensional representation of the data.
}
\description{
Creates a k-dimensional representation of the data. As input, a subsample and
its k-dimensional mapping (control points) are required. The method
approximates the subsample mapping to a linear mapping and then applies the
same mapping to all instances.
}
\examples{

# Iris example
emb <- plmp(iris[,1:4])
plot(emb, col=iris$Species)

}
\references{
Paulovich, F.V.; Silva, C.T.; Nonato, L.G., "Two-Phase Mapping
  for Projecting Massive Data Sets," Visualization and Computer Graphics,
  IEEE Transactions on , vol.16, no.6, pp.1281,1290, Nov.-Dec. 2010.
}

