% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmfence.R
\name{glmfence}
\alias{glmfence}
\title{The fence procedure for generalised linear models}
\usage{
glmfence(mf, cstar, nvmax, adaptive = TRUE, trace = TRUE, ...)
}
\arguments{
\item{mf}{an object of class \code{\link[stats]{glm}}
specifying the full model.}

\item{cstar}{the boundary of the fence, typically found
through bootstrapping.}

\item{nvmax}{the maximum number of variables that will be
be considered in the model.}

\item{adaptive}{logical. If \code{TRUE} the boundary of the fence is
given by cstar.  Otherwise, it the original (non-adaptive) fence
is performed where the boundary is cstar*hat(sigma)_{M,tildeM}.}

\item{trace}{logical. If \code{TRUE} the function prints out its
progress as it iterates up through the dimensions.}

\item{...}{further arguments (currently unused)}
}
\description{
This function implements the fence procedure to
find the best generalised linear model.
}
\references{
Jiming Jiang, Thuan Nguyen, J. Sunil Rao,
A simplified adaptive fence procedure, Statistics &
Probability Letters, Volume 79, Issue 5, 1 March 2009,
Pages 625-629, http://dx.doi.org/10.1016/j.spl.2008.10.014.
}
\seealso{
\code{\link{af}}, \code{\link{lmfence}}

Other fence: 
\code{\link{af}()},
\code{\link{lmfence}()}
}
\concept{fence}
\keyword{Internal}
