% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_effect_main_QEI.R
\name{QTL_effect_main_QEI}
\alias{QTL_effect_main_QEI}
\title{Main and QTL by environment interaction model}
\usage{
QTL_effect_main_QEI(
  mppData,
  trait,
  env_id = NULL,
  ref_env = NULL,
  ref_par = NULL,
  VCOV = "UN",
  QTL = NULL,
  maxIter = 100,
  msMaxIter = 100
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{env_id}{\code{Character} vector specifying the environment names.
By default, E1, ... En}

\item{ref_env}{Optional \code{Character} expression defining the environment
that will be used as reference for the parental model. By default, the last
environment is set as reference.}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. Default = NULL}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected marker positions obtained with the function QTL_select() or
a vector of \code{character} marker positions names. Default = NULL.}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}
}
\value{
Return:

\code{List} with one \code{data.frame} per QTL that contains the following
elements:

\enumerate{

\item{To be filled}

\item{To be filled}

\item{Significance of the parent main effect expressed as the -log10(p-val)}

\item{Significance of the parent QTLxE effect expressed as the -log10(p-val)}

}
}
\description{
The function estimate a QTL model where each parental QTL allelic effect is
decomposed into a main effect and a QTL by environment effect (QEI). It allows
the user to determine which parental allelic effects have a significant
interaction with the environment.
}
\details{
The function estimate the following model

\eqn{y_{icj} = E_j + C_{c_j} + \sum_{q=1}^{n_{QTL}}{x_{i_{q}p}*(\alpha_{p} + \beta_{pj})} + GE_{ijc} + e_{ijc}}

where the QTL effect is decomposed into \eqn{\alpha_{p}} that represent the
main parental allelic effect across environments and \eqn{\beta_{pj}} which is
the QEI effect. allelic effects must be interpreted as deviation with respect
to the reference parent ('ref_par') in the reference environment ('ref_env').
By default the reference parent is the one with the highest allelic frequency
(e.g. central parent in a NAM population).

The estimation is performed using an exact mixed model with function from R
package \code{nlme}. The significance of the allele effect is assessed using a 
Wald test.
}
\examples{

\dontrun{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

Qeff <- QTL_effect_main_QEI(mppData = mppData_GE,
                            trait = c('DMY_CIAM', 'DMY_TUM', 'DMY_INRA_P', 'DMY_KWS'),
                            env_id = c('CIAM', 'TUM', 'INRA', 'KWS'),
                            QTL = Qpos)

Qeff

}

}
\references{
Pinheiro J, Bates D, DebRoy S, Sarkar D, R Core Team (2021). nlme: Linear
and Nonlinear Mixed Effects Models_. R package version 3.1-152,
<URL: https://CRAN.R-project.org/package=nlme>.
}
\author{
Vincent Garin
}
