% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{optparasearch}
\alias{optparasearch}
\alias{print.optparasearch}
\title{Parameters Search}
\usage{
optparasearch(
  X,
  Y = NULL,
  Z = NULL,
  search.method = c("ncomp1st", "regpara1st", "regparaonly", "simultaneous")[1],
  eta = 1,
  type = "lasso",
  inX = NULL,
  inY = NULL,
  muX = 0,
  muY = 0,
  comp = 10,
  nfold = 5,
  maxrep = 3,
  minpct = 0,
  maxpct = 1,
  maxpct4ncomp = NULL,
  criterion = c("BIC", "CV")[1],
  criterion4ncomp = NULL,
  whichselect = NULL,
  homo = NULL,
  intseed = 1
)

\method{print}{optparasearch}(x, ...)
}
\arguments{
\item{X}{a matrix or list of matrices indicating the explanatory variable(s). This parameter is required.}

\item{Y}{a matrix or list of matrices indicating objective variable(s). This is optional. If there is no input for Y, then PCA is implemented.}

\item{Z}{a vector, response variable(s) for implementing the supervised version of (multiblock) PCA or PLS. This is optional. The length of Z is the number of subjects. If there is no input for Z, then unsupervised PLS/PCA is implemented.}

\item{search.method}{a character indicationg search methods, see Details. Default is "ncomp1st" (this is version 3.0 or later).}

\item{eta}{numeric scalar indicating the parameter indexing the penalty family. This version contains only choice 1.}

\item{type}{a character, indicating the penalty family. In this version, only one choice is available: "lasso."}

\item{inX}{a vector or list of numeric vectors specifying the variables in X, always included in the model}

\item{inY}{a vector or list of numeric vectors specifying the variables in Y, always included in the model}

\item{muX}{a numeric scalar for the weight of X for the supervised case. 0 <= muX <= 1.}

\item{muY}{a numeric scalar for the weight of Y for the supervised case. 0 <= muY <= 1.}

\item{comp}{numeric scalar for the number of components to be considered or the maximum canditate number of components.}

\item{nfold}{number of folds - default is 5.}

\item{maxrep}{numeric scalar for the number of iteration.}

\item{minpct}{minimum candidate parameters defined as a percentile of automatically determined (possible) candidates.}

\item{maxpct}{maximum candidate parameters defined as a percentile of automatically determined (possible) candidates.}

\item{maxpct4ncomp}{maximum candidate parameters defined as a percentile of automatically determined (possible) candidates.}

\item{criterion}{a character, the evaluation criterion, "CV" for cross-validation, based on a matrix element-wise error, and "BIC" for Bayesian information criteria. The "BIC" is the default.}

\item{criterion4ncomp}{a character, the evaluation criterion for the selection of the number of components, "CV" for cross-validation, based on a matrix element-wise error, and "BIC" for Bayesian information criteria.}

\item{whichselect}{which blocks selected.}

\item{homo}{same parameters.}

\item{intseed}{seed number for the random number in the parameter estimation algorithm.}

\item{x}{an object of class "\code{optparasearch}", usually, a result of a call to \code{optparasearch}}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{optncomp}{Optimal number of components}

\item{optlambdaX}{Optimal parameters for X}

\item{optlambdaY}{Optimal parameters for Y}

\item{mincriterion}{Minimum criterion value}

\item{criteria}{All resulting criterion values in the process}

\item{pararange}{Range of candidates parameters}
}
\description{
Combined method for optimizing the number of components and regularized parameters for "msma".
}
\details{
A function for identifying the regularized sparseness parameters lambdaX and lambdaY and the number of components for \code{msma}. Four search methods are available. The "simultaneous" method identifies the number of components by searching the regularized parameters in each component. The "regpara1st" identifies the regularized parameters by fixing the number of components, then searching for the number of components with the selected regularized parameters. The "ncomp1st" method identifies the number of components with a regularized parameter of 0, then searches for the regularized parameters with the selected number of components. The "regparaonly" method searches for the regularized parameters with a fixed number of components.
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### Regularized parameters search #####
opt1 = optparasearch(X, Y, search.method = "regparaonly", comp=1, nfold=5, maxrep=2)
opt1
fit4 = msma(X, Y, comp=opt1$optncomp, lambdaX=opt1$optlambdaX, lambdaY=opt1$optlambdaY)
fit4
summary(fit4)

##### Restrict search range #####
opt2 = optparasearch(X, Y, comp=3, nfold=5, maxrep=2, minpct=0.5)
opt2

}
