% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{gen_profile}
\alias{gen_profile}
\title{Generate protein ratio profile from spectrum quantification matrix.}
\usage{
gen_profile(x, method = "sum", method.denom = "first")
}
\arguments{
\item{x}{matrix of spectrum quantification values, one row per spectrum and
one column per channel}

\item{method}{method to use to "roll up" spectrum values to protein level}

\item{method.denom}{method used to determine ratio denominator, passed as
the "method" argument to \code{abs_to_ratio}}
}
\value{
A numeric vector of the same length as the number of matrix columns
}
\description{
\code{gen_profile} takes a matrix of spectrum channel
quantification values belonging to a protein and "rolls them up" into a
vector of protein-level relative quantification values.
}
\details{
The following methods for spectrum-to-protein conversion are
supported:
    \describe{
       \item{"sum"}{use the sum of the Spectrum values for each channel}
       \item{"median"}{use the median of the spectrum values for each
         channel}
       \item{"ratio.median"}{Like "median", but values for each spectrum
         are first converted to ratios according to "method.denom"
         channel}
       \item{"ratio.mean"}{Like "ratio.median" but using mean of ratios}
    }
}
\keyword{internal}
