% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{alignment}
\alias{alignment}
\title{Align the initializations.}
\usage{
alignment(mu1, mu2, method = c("exhaustive", "greedy"))
}
\arguments{
\item{mu1}{the initializations for mu1 of all tasks. Should be a matrix of which each column is a mu1 estimate of a task.}

\item{mu2}{the initializations for mu2 of all tasks. Should be a matrix of which each column is a mu2 estimate of a task.}

\item{method}{alignment method. Can be either "exhaustive" (Algorithm 2 in Tian, Y., Weng, H., & Feng, Y. (2022)) or "greedy" (Algorithm 3 in Tian, Y., Weng, H., & Feng, Y. (2022)). Default: "exhaustive"}
}
\value{
the index of two clusters to become well-aligned, i.e. the "r_k" in Section 2.4.2 of Tian, Y., Weng, H., & Feng, Y. (2022). The output can be passed to function \code{\link{alignment_swap}} to obtain the well-aligned intializations.
}
\description{
Align the initializations. This function implements the two alignment algorithms (Algorithms 2 and 3) in Tian, Y., Weng, H., & Feng, Y. (2022). This function is mainly for people to align the single-task initializations manually. The alignment procedure has been automatically implemented in function \code{mtlgmm} and \code{tlgmm}. So there is no need to call this function when fitting MTL-GMM or TL-GMM.
}
\note{
For examples, see part "fit signle-task GMMs" of examples in function \code{\link{mtlgmm}}.
}
\references{
Tian, Y., Weng, H., & Feng, Y. (2022). Unsupervised Multi-task and Transfer Learning on Gaussian Mixture Models. arXiv preprint arXiv:2209.15224.
}
\seealso{
\code{\link{mtlgmm}}, \code{\link{tlgmm}}, \code{\link{predict_gmm}}, \code{\link{data_generation}}, \code{\link{initialize}}, \code{\link{alignment_swap}}, \code{\link{estimation_error}}, \code{\link{misclustering_error}}.
}
