% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diabetes.R
\docType{data}
\name{diabetes}
\alias{diabetes}
\title{Network meta-analysis studying the incidence of diabetes}
\format{
A data frame with the following columns:
\tabular{rl}{
\bold{\emph{study}}\tab study label \cr
\bold{\emph{id}}\tab study id \cr
\bold{\emph{t}}\tab treatment label \cr
\bold{\emph{r}}\tab number of events \cr
\bold{\emph{n}}\tab group sample size \cr
\bold{\emph{rob}}\tab risk of bias assessment
}
}
\source{
Elliott WJ, Meyer PM (2007):
Incident diabetes in clinical trials of antihypertensive drugs:
A network meta-analysis
\emph{Lancet},
\bold{369}, 201--7,
\doi{10.1016/S0140-6736(07)60108-1}
}
\description{
Network meta-analysis comparing six antihypertensive drugs against the
incidence of diabetes.
}
\examples{
data(diabetes)
head(diabetes)
#
\donttest{
pw <- pairwise(studlab = study, treat = t,
  n = n, event = r, data = diabetes, sm = "OR")
#
net <- netmeta(pw, reference.group = "PLA")
#
ranks <- tcc(net, swd = 1.20, small.values = "desirable")
#
forest(ranks)
forest(ranks, reference.group = "ARB", baseline.reference = FALSE)
}
}
\seealso{
\code{\link{mtrank}}, \code{\link{tcc}}
}
\keyword{datasets}
