% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtrank.R
\name{mtrank}
\alias{mtrank}
\alias{print.mtrank}
\title{Estimate the treatment hierarchy in network meta-analysis using a
probabilistic ranking model}
\usage{
mtrank(x, level = x$level, ...)

\method{print}{mtrank}(
  x,
  sorting = "ability",
  backtransf = FALSE,
  digits = gs("digits"),
  digits.prop = gs("digits.prop"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{tcc}} or \code{\link{mtrank}}
(print function).}

\item{level}{The level used to calculate confidence intervals for ability
estimates.}

\item{\dots}{Additional arguments (passed on to
\code{\link[PlackettLuce]{PlackettLuce}} or to \code{\link{prmatrix}}).}

\item{sorting}{An argument specifying the criterion to sort the ability
estimates in the printout (see Details).}

\item{backtransf}{A logical argument specifying whether to show log-ability
estimates (\code{FALSE}, default) or on the natural scale (\code{TRUE}).}

\item{digits}{Minimal number of significant digits for ability estimates,
see \code{print.default}.}

\item{digits.prop}{Minimal number of significant digits for proportions,
see \code{print.default}.}
}
\value{
\itemize{
\item A data frame containing the resulting log-ability estimates, their
  standard errors and their confidence intervals.
\item The estimate of the tie prevalence parameter v, on the log-scale.
\item The normalized ability estimates for each treatment. 
}
}
\description{
This function fits the Davidson-Bradley-Terry ranking model and produces a
treatment hierarchy based on the method described by
Evrenoglou et al. (2024) for network meta-analysis.
}
\details{
This function fits a Davidson-Bradley-Terry model to the treatment preferences
\code{\link{tcc}} function. It estimates the ability of
each treatment to outperform the other treatments in the network, along with
the respective standard errors, using a maximum likelihood approach.
The term 'ability to outperform' refers to a latent characteristic that
indicates the propensity of each treatment in the network to yield clinically
relevant and beneficial treatment effects, in the context of the defined
treatment choice criterion, when compared to the rest of the treatments.
Consequently, treatments with larger ability estimates are ranked more
prominently in the treatment hierarchy.

To retain identifiability, the maximization of the log-likelihood takes place
subject to the constrain that the ability estimates sum to 1. Then, the
maximum likelihood estimates (MLEs) are calculated iteratively. Note that the
final estimates of the ability parameters are not necessarily needed to sum
to 1 as after the first iteration of the algorithm the ability estimates are
not normalized. However, by normalizing the final ability estimates to sum up
to 1 these can be interpreted as "the probability that each treatment is
having the highest ability".

Finally, a parameter "v" controlling the prevalence of ties in the network
is also estimated. Although the estimated values of this parameter do not
have a direct interpretation they are useful for estimating the fitted
pairwise probabilities (see \code{\link{fitted.mtrank}}).
}
\examples{
data("antidepressants")
#
pw <- pairwise(studlab = studyid, treat = drug_name,
  n = ntotal, event = responders,
  data = antidepressants, sm = "OR")
# Use subset to reduce runtime
pw <- subset(pw, studyid < 60)
#
net <- netmeta(pw, reference.group = "tra")

ranks <- tcc(net, swd = 1.20, small.values = "undesirable")
#
fit <- mtrank(ranks)

# Print log-ability estimates
fit
#
# Print ability estimates
print(fit, backtransf = TRUE)

# Visualize results
forest(fit)
 
}
\references{
Evrenoglou T, Nikolakopoulou A, Schwarzer G, Rücker G, Chaimani A (2024):
Producing treatment hierarchies in network meta-analysis using probabilistic
models and treatment-choice criteria,
\url{https://arxiv.org/abs/2406.10612}
}
