% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp2long.R
\name{pp2long}
\alias{pp2long}
\title{Auxiliary function to transform data from paired-preference to
long-arm format}
\usage{
pp2long(x)
}
\arguments{
\item{x}{An object of class "ppdata" (part of \code{\link{tcc}} object).}
}
\value{
Data set in long-arm format that can be used as input to
\code{\link[PlackettLuce]{rankings}}.
}
\description{
Auxiliary function to transform data from paired-preference to
long-arm format
}
\examples{
data(diabetes)
#
pw <- pairwise(studlab = study, treat = t,
  n = n, event = r, data = diabetes, sm = "OR")
# Use subset to reduce runtime
pw1 <- subset(pw, id >= 6 & id <= 10)
net1 <- netmeta(pw1, reference.group = "PLA")
#
ranks1 <- tcc(net1, swd = 1.20, small.values = "desirable")
#
pdat1 <- ranks1$ppdata
#
ldat1 <- pp2long(pdat1)
head(ldat1)

\donttest{
net <- netmeta(pw, reference.group = "PLA")
#
ranks <- tcc(net, swd = 1.20, small.values = "desirable")
#
pdat <- ranks$ppdata
#
ldat <- pp2long(pdat)
head(ldat)

library("PlackettLuce")
preferences <- rankings(ldat, id = "id", item = "treat", rank = "rank")
#
fit <- PlackettLuce(preferences)
#
coef(summary(fit, ref = ranks$reference.group))[, 1]
# Results stored in mtrank()
mtrank(ranks)$estimates$log_ability
}

}
\seealso{
\code{\link{tcc}}, \code{\link[PlackettLuce]{rankings}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
