% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gee_criteria.R
\name{gee_criteria}
\alias{gee_criteria}
\title{Variable and Covariance Selection Criteria}
\usage{
gee_criteria(object, ...)
}
\arguments{
\item{object}{an object of the class \code{LORgee}.}

\item{...}{optionally more objects of the class \code{LORgee}.}
}
\value{
A vector or matrix with the QIC, QICu, CIC, RJC and the number of 
regression parameters (including intercepts).
}
\description{
Reports commonly used criteria for variable selection 
and for selecting the "working" association structure for one or several 
fitted models from the \code{multgee} package.
}
\details{
The Quasi Information Criterion (QIC), the Correlation Information Criterion
(CIC) and the Rotnitzky and Jewell Criterion (RJC) are used for selecting the
best association structure. The QICu criterion is used for selecting the best 
subset of covariates. When choosing among GEE models with different association
structures but with the same subset of covariates, the model with the smallest 
value of QIC, CIC or RJC should be preffered. When choosing between GEE models
with different number of covariates, the model with the smallest QICu value 
should be preferred.
}
\examples{
data(arthritis)
fitmod <- ordLORgee(formula = y ~ factor(time) + factor(trt) + factor(baseline),
data = arthritis, id = id, repeated = time, LORstr = "uniform")
fitmod1 <- update(fitmod, formula = .~. + age + factor(sex))
gee_criteria(fitmod, fitmod1)
}
\references{
Hin, L.Y. and Wang, Y.G. (2009) Working correlation structure 
identification in generalized estimating equations. \emph{Statistics in 
Medicine} \bold{28}, 642--658.

Pan, W. (2001) Akaike's information criterion in generalized 
estimating equations. \emph{Biometrics} \bold{57}, 120--125.

Rotnitzky, A. and Jewell, N.P. (1990) Hypothesis testing of regression 
parameters in semiparametric generalized linear models for cluster correlated
data. \emph{Biometrika} \bold{77}, 485--497.
}
\seealso{
\link{nomLORgee} and \link{ordLORgee}.
}
\author{
Anestis Touloumis
}
