% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsm_model.R
\name{rsm_model}
\alias{rsm_model}
\title{Random stub matching model for multigraphs}
\usage{
rsm_model(deg.seq)
}
\arguments{
\item{deg.seq}{vector of integers representing the degree sequence of a multigraph.}
}
\value{
\item{m.seq}{possible multigraphs represented by edge multiplicity sequences}
\item{prob.dists}{probability distribution of the multigraphs/edge multiplicity sequences,
and the probability distributions of the statistics \emph{number of loops},
\emph{number of multiple edges}, and
\emph{simple graph} (logical) for each multigraph}
\item{M}{summary of moments and interval estimates for
\emph{number of loops} and \emph{number of multiple edges} (\code{M1} and \code{M2})).}
}
\description{
Given a specified degree sequence,
this function finds all unique multigraphs represented
by their edge multiplicity sequences. Different
complexity statistics together with their
probability distributions and moments are calculated.
}
\details{
The probability distributions of all unique multigraphs given fixed degree sequence,
together with the first two central moments and interval estimates of the statistics
\emph{M1 = number of loops} and \emph{M2 = number of multiple edges}, under the RSM model are calculated.

For other structural statistics and for large multigraphs,
use the IEA approximation of the RSM model via the function \code{\link{iea_model}}
}
\examples{
# Given a specified degree sequence
D <- c(2, 2, 3, 3) # degree sequence
mod1 <- rsm_model(D)
mod1$m.seq
mod1$prob.dists
mod1$M

# Given an observed graph
A <- matrix(c(
    0, 1, 2,
    1, 2, 1,
    2, 1, 2
), nrow = 3, ncol = 3)
D <- get_degree_seq(adj = A, type = "graph")
mod2 <- rsm_model(D)
}
\references{
Shafie, T. (2015). A Multigraph Approach to Social Network Analysis. \emph{Journal of Social Structure}, 16.
\cr

Shafie, T. (2016). Analyzing Local and Global Properties of Multigraphs. \emph{The Journal of Mathematical Sociology}, 40(4), 239-264.
}
\seealso{
\code{\link{get_degree_seq}}, \code{\link{get_edge_multip_seq}}, \code{\link{iea_model}}
}
\author{
Termeh Shafie
}
