% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactMatrixAgeSchool.R
\name{contactMatrixAgeSchool}
\alias{contactMatrixAgeSchool}
\title{Calculate a contact matrix for age groups and schools}
\usage{
contactMatrixAgeSchool(
  agelims,
  agepops,
  schoolagegroups,
  schoolpops,
  schportion
)
}
\arguments{
\item{agelims}{minimum age in years for each age group}

\item{agepops}{population size of each age group}

\item{schoolagegroups}{index of the age group covered by each school}

\item{schoolpops}{population size of each school}

\item{schportion}{portion of within-age-group contacts that are exclusively within school}
}
\value{
a square matrix with the contact rate of each group (row) with members of each
other group (column)
}
\description{
Calculate a contact matrix for age groups and schools
}
\examples{
contactMatrixAgeSchool(agelims = c(0, 5, 18), agepops = c(500, 1300, 8200),
schoolagegroups = c(2, 2), schoolpops = c(600, 700), schportion = 0.7)
}
