% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{lm_model}
\alias{lm_model}
\title{Linear Model across Responses}
\usage{
lm_model(progress = TRUE)
}
\arguments{
\item{progress}{A logical indicating whether to show a progress bar during
estimation.}
}
\value{
model An object of class \code{model} with estimator, predictor, and
sampler functions associated wtih a linear model.
}
\description{
Apply a linear model in parallel across each response $y$ in an outcome or
mediation model. This is often useful for mediator models with few
pretreatment variables, since each input is low-dimensional, even when there
are many responses.
}
\examples{
m <- lm_model()
estimator(m)(mpg ~ hp + wt, data = mtcars)
}
\seealso{
model
}
