% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimediate_survival.R
\name{multimediate_survival}
\alias{multimediate_survival}
\title{multimediate_survival - internal function}
\usage{
multimediate_survival(
  lmodel.m,
  correlated = FALSE,
  model.y,
  treat,
  treat.value = 1,
  control.value = 0,
  J = 1000,
  conf.level = 0.95,
  fun = mean,
  data = NULL,
  peryr = 1e+05,
  verbose = TRUE
)
}
\arguments{
\item{lmodel.m}{A list of fitted mediator models (`lm`, `glm`, or `polr` objects).}

\item{correlated}{a logical value. if 'FALSE' a identity matrix is used for the matrix of correlation of mediators; if 'TRUE' matrix of correlation is estimated. Default is 'FALSE'.}

\item{model.y}{A fitted outcome model (`lm`, `glm`, `polr`, or `aalen` object).}

\item{treat}{The name of the treatment variable (character).}

\item{treat.value}{The value representing the treatment condition (default: 1).}

\item{control.value}{The value representing the control condition (default: 0).}

\item{J}{Number of Monte Carlo simulations for effect estimation (default: 1000).}

\item{conf.level}{Confidence level for confidence intervals (default: 0.95).}

\item{fun}{A summary function applied to the simulated effects (default: `mean`).}

\item{data}{A data frame containing the variables used in the models.}

\item{peryr}{Scaling factor for incidence rates per person-year (default: 100,000).}

\item{verbose}{Logical. If `TRUE` (default), messages and a progress bar are displayed during execution.}
}
\value{
A list containing estimated direct, indirect (mediated), and total effects,
along with confidence intervals and p-values for each.
}
\description{
multimediate_survival - internal function
}
\keyword{internal}
