% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca}
\alias{pca}
\title{Principal Components Analysis (PCA)}
\usage{
pca(
  X,
  ncomp = min(dim(X)),
  preproc = center(),
  method = c("fast", "base", "irlba", "propack", "rsvd", "svds"),
  ...
)
}
\arguments{
\item{X}{The data matrix.}

\item{ncomp}{The number of requested components to estimate (default is the minimum dimension of the data matrix).}

\item{preproc}{The pre-processing function to apply to the data matrix (default is centering).}

\item{method}{The SVD method to use, passed to \code{svd_wrapper} (default is "fast").}

\item{...}{Extra arguments to send to \code{svd_wrapper}.}
}
\value{
A \code{bi_projector} object containing the PCA results.
}
\description{
Compute the directions of maximal variance in a data matrix using the Singular Value Decomposition (SVD).
}
\examples{
data(iris)
X <- as.matrix(iris[, 1:4])
res <- pca(X, ncomp = 4)
tres <- truncate(res, 3)
}
\seealso{
\code{\link{svd_wrapper}} for details on SVD methods.
}
