% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{transfer}
\alias{transfer}
\title{Transfer data from one domain/block to another via a latent space}
\usage{
transfer(x, new_data, from, to, opts = list(), ...)
}
\arguments{
\item{x}{The model fit, typically an object that implements a \code{transfer} method
and ideally a \code{block_names} method.}

\item{new_data}{The data to transfer, typically matching the dimension of the \code{from} domain.}

\item{from}{Character string or index identifying the source domain/block.
Must be present in \code{block_names(x)} if that method exists.}

\item{to}{Character string or index identifying the target domain/block.
Must be present in \code{block_names(x)} if that method exists.}

\item{opts}{A list of optional arguments controlling the transfer process:
\describe{
\item{\code{cols}}{Optional numeric vector specifying column indices of the \emph{target}
domain to reconstruct. If NULL (default), reconstructs all columns.}
\item{\code{comps}}{Optional numeric vector specifying which latent components to use
for the projection/reconstruction. If NULL (default), uses all components.}
\item{\code{ls_rr}}{Logical; if TRUE, use a ridge-regularized LS approach for the
initial projection from the \code{from} domain. Default FALSE.}
\item{\code{lambda}}{Numeric ridge penalty (if \code{ls_rr=TRUE}). Default 1e-6.}
}}

\item{...}{Additional arguments passed to specific methods (discouraged, prefer \code{opts}).}
}
\value{
A matrix or data frame representing the transferred data in the \code{to} domain/block
(or a subset of columns/components if specified in \code{opts}).
}
\description{
Convert between data representations in a multiblock or cross-decomposition
model by projecting the input \code{new_data} from the \code{from} domain/block
onto a latent space and then reconstructing it in the \code{to} domain/block.
}
