% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.multiview.R
\name{coef.cv.multiview}
\alias{coef.cv.multiview}
\title{Extract coefficients from a cv.multiview object}
\usage{
\method{coef}{cv.multiview}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{Fitted \code{"cv.multiview"} object.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the value \code{s="lambda.1se"}
stored on the CV \code{object}. Alternatively \code{s="lambda.min"} can be
used. If \code{s} is numeric, it is taken as the value(s) of \code{lambda}
to be used. (For historical reasons we use the symbol 's' rather
than 'lambda' to reference this parameter.)}

\item{...}{This is the mechanism for passing arguments like \verb{x=} when
\code{exact=TRUE}; see \code{exact} argument.}
}
\value{
the matrix of coefficients for specified lambda.
}
\description{
Extract coefficients from a cv.multiview object
}
\examples{
set.seed(1)
x = matrix(rnorm(100*20), 100, 20)
z = matrix(rnorm(100*20), 100, 20)
U = matrix(rnorm(100*5), 100, 5)
for (m in seq(5)){
    u = rnorm(100)
    x[, m] = x[, m] + u
    z[, m] = z[, m] + u
    U[, m] = U[, m] + u}
x = scale(x, center = TRUE, scale = FALSE)
z = scale(z, center = TRUE, scale = FALSE)
beta_U = c(rep(0.1, 5))
y = U \%*\% beta_U + 0.1 * rnorm(100)
fit1 = cv.multiview(list(x=x,z=z), y, rho = 0.3)
coef(fit1, s="lambda.min")

# Binomial
\donttest{
by = 1 * (y > median(y)) 
fit2 = cv.multiview(list(x=x,z=z), by, family = binomial(), rho = 0.9)
coef(fit2, s="lambda.min")

# Poisson
py = matrix(rpois(100, exp(y))) 
fit3 = cv.multiview(list(x=x,z=z), py, family = poisson(), rho = 0.6)
coef(fit3, s="lambda.min")
}
}
